Notebook[{

Cell[CellGroupData[{
Cell["\<\

From Jordan to Einstein frames in Scalar-tensor theories (using xConf)\
\>", "Subtitle",
 FontSize->24,ExpressionUUID->"b73ea991-a1e7-4945-91d0-4054ec287b18"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", 
  RowBox[{"\"\<xAct`xConf`\>\"", ",", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ParentDirectory", "@", 
       RowBox[{"Directory", "[", "]"}]}], ",", "\"\<xConf.m\>\""}], "}"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"678b56c2-43ca-42da-a7c6-2d1dc4257ac4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"1beef6f9-02ab-45b9-adbe-021671169513"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"7978ce6d-efc9-4e77-9a1b-d553c41b5fbe"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"2e36436a-95fb-4536-8d6f-6831ad4f7e7d"],

Cell[BoxData["\<\"Connecting to external linux executable...\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"60168533-e29b-4381-a1f0-714f83913ecf"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"3640aec4-501b-4b7a-819d-c63c905702c3"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"1b1e3ede-48d8-4ca1-b5b4-c0bd04286b1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"849b3fdf-82f1-4990-9e65-c9af30e85138"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9e4bd0d4-9639-468d-a386-f8547b4e07cf"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"76982200-51f5-45f7-b070-fa0dec20ecaf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xConf`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.0.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "4", ",", "4"}], "}"}]}],
  SequenceForm["Package xAct`xConf`  version ", "0.0.1", ", ", {2025, 4, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"5242fbdb-4051-47a4-86c4-1bc733357a18"],

Cell[BoxData["\<\"CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"1f0712c4-6b0c-4740-a9b9-b56951d5ecba"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"00eaec90-fcab-4d25-8f0e-ebb9cdc6f55c"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"4e9df832-c643-43b4-b12f-d6db7c80fed7"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"a70ed0bb-27e6-4f31-b706-4e196ebea821"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"c2b473ed-436b-4348-9603-9150958b1f32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "UseMetricOnVBundle", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ToCanonical", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "All", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "None"}],
  SequenceForm[
  "** Option ", xAct`xTensor`UseMetricOnVBundle, " of ", 
   xAct`xTensor`ToCanonical, " changed from ", All, " to ", None],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"2800068d-b9d6-415c-b0bd-33341282c983"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Mu]", ",", "\[Nu]", 
     ",", "\[Lambda]", ",", "\[Sigma]"}], "}"}]}], "]"}], "\n", 
 RowBox[{
  RowBox[{"DefMetric", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}]}], "]"}], ",", "CD", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<\[Del]\>\""}], "}"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"e5a250ec-cb66-4862-b7ba-440ac45c6456"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"90495380-48d5-4b3a-9a82-4e29eb490549"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"0be47c46-7d5d-4923-bf12-986f216d81e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"203a3778-12fd-4531-89b5-fae17d51cea3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"16e4b114-32b4-404d-aec5-0ef9d76dcf0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"3cf080ae-735e-4e1d-bd1b-06e2765d4c73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"e53c0d52-86f8-42fd-8c77-54c4eff9277f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"98b198e9-41f3-45dd-a8ac-5a7900151564"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"af58a02c-d383-4be7-b38f-aa12efef0afe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"2f51e2af-c258-43c8-8952-2aa8ec6f7a94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"b8754bcc-190c-4abc-a141-7621f62cf8c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"275e688c-fafd-43e4-83de-1a6da94ed13e"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"42b09fc5-73fd-4c10-851c-22fd41fa4388"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"4ee1ad73-c871-436a-948b-100080fb1cd2"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"cbefeef8-f9e6-45f1-ba71-621298f7ef4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"13b68870-ce05-4ba4-9741-11bcff45b312"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"6c7990c5-f52b-402a-bb93-5e23ad92f8ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"cfbd6400-856c-43c4-9bd3-c433d3f99580"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"ef721d58-ae30-4bd2-891d-eb9bd4db9677"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"d8206bcd-8b5b-424e-a97d-193e80c67d66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"9aa06910-7971-48da-97e4-8d59ed888788"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"f4190fa3-27ad-4e7d-9156-92fb720b13c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"c163f50e-fedf-40ed-88f1-f5eef98c93a0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining scalar fields ", \
"Subsubsection",ExpressionUUID->"1375e1fe-c393-4181-ac0c-be6cba05ba57"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"sqrtF", "[", "]"}], ",", "M"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"F", "[", "]"}], ",", "M"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"\[CurlyPhi]", "[", "]"}], ",", "M"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefScalarFunction", "[", 
  RowBox[{"Fof\[CurlyPhi]", ",", 
   RowBox[{"PrintAs", "->", "\"\<F\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefScalarFunction", "[", 
  RowBox[{"Fof\[Chi]", ",", 
   RowBox[{"PrintAs", "->", "\"\<F\>\""}]}], "]"}]}], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"34de1f47-2f8f-4fb1-bad9-ec1598b4aa85"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"sqrtF", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`sqrtF[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7ff49831-9cf2-4d77-931f-6cce4388ae44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"F", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`F[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"afef7d00-0b41-4277-8b11-787463219d94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[CurlyPhi]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[CurlyPhi][], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a1070a3b-d80d-4624-b646-e684238a35b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefScalarFunction", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"scalar function \"\>", "\[InvisibleSpace]", 
   "Fof\[CurlyPhi]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefScalarFunction, ": Defining ", 
   "scalar function ", $CellContext`Fof\[CurlyPhi], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"96cf1851-5fb2-4da3-8c04-6a339dc15a0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefScalarFunction", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"scalar function \"\>", "\[InvisibleSpace]", 
   "Fof\[Chi]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefScalarFunction, ": Defining ", 
   "scalar function ", $CellContext`Fof\[Chi], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8ffba9ad-058a-4ff9-82b4-d259be316913"]
}, Open  ]]
}, Open  ]],

Cell["The scalar potentials of the model", \
"Text",ExpressionUUID->"6cd6d3ce-4631-43b8-a7ec-e4ec5f795c09"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Jordan", " ", "frame", " ", "potential"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"DefScalarFunction", "[", 
    RowBox[{"VJ", ",", 
     RowBox[{
     "PrintAs", "->", "\"\<\!\(\*SubscriptBox[\(V\), \(J\)]\)\>\""}]}], "]"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"ConformalWeight", "[", 
       RowBox[{"VJ", "'"}], "]"}], "=", "0"}], ";"}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Einstein", " ", "frame", " ", "potential"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"DefScalarFunction", "[", 
    RowBox[{"VE", ",", 
     RowBox[{
     "PrintAs", "->", "\"\<\!\(\*SubscriptBox[\(V\), \(E\)]\)\>\""}]}], "]"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"ConformalWeight", "[", 
       RowBox[{"VE", "'"}], "]"}], "=", "0"}], ";"}], "*)"}]}]}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"5b927bee-2963-485f-9613-4073fdf7de0a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefScalarFunction", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"scalar function \"\>", "\[InvisibleSpace]", "VJ",
    "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefScalarFunction, ": Defining ", 
   "scalar function ", $CellContext`VJ, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"1cb71a12-a27c-4b43-ba9e-e6a8516ade8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefScalarFunction", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"scalar function \"\>", "\[InvisibleSpace]", "VE",
    "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefScalarFunction, ": Defining ", 
   "scalar function ", $CellContext`VE, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"06dea433-a4bc-49f4-bb5d-5ca19218860c"]
}, Open  ]]
}, Open  ]],

Cell["We check that the scalar fields have no conformal weight", \
"Text",ExpressionUUID->"9fecb09c-8bb3-46a4-963f-892243b14859"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"14823953-355c-4979-8e74-2cba9cc90910"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[14]=",ExpressionUUID->"f1363ee2-f095-4c75-8ecc-2cf7299e24d3"]
}, Open  ]],

Cell["\<\
We also say that they are invariant hence they have the same expressions in \
all frames.\
\>", "Text",ExpressionUUID->"37ea8097-9ac6-440a-b87f-35537ab58c29"],

Cell["\<\
These simplification rules can be necessary since Mathematica does not \
necessarily know that the conformal factor is positive\
\>", "Text",ExpressionUUID->"5131e951-7906-4120-a663-f1626660e1fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"sqrtF", "[", "]"}], ">", "0"}], "&&", 
     RowBox[{
      RowBox[{"F", "[", "]"}], ">", "0"}], "&&", 
     RowBox[{
      RowBox[{"Fof\[CurlyPhi]", "[", 
       RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], ">", "0"}], "&&", 
     RowBox[{
      RowBox[{"Fof\[Chi]", "[", 
       RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], ">", "0"}]}], ")"}]}], 
  ";"}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"e56257d4-9de7-4c04-a34e-0ed625524110"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RulesqrtF", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"sqrtF", "[", "]"}], ":>", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"F", "[", "]"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"sqrtF", "[", "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"pow_", "?", "EvenQ"}], ")"}]}], ":>", 
     RowBox[{
      RowBox[{"F", "[", "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"pow", "/", "2"}], ")"}]}]}]}], "}"}]}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"8144e1ab-460f-446e-8a27-420c9b5081c8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox["sqrtF",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`sqrtF[],
     Editable->False], "\[RuleDelayed]", 
    SqrtBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F[],
      Editable->False]]}], ",", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["sqrtF",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`sqrtF[],
      Editable->False], 
     RowBox[{"pow_", "?", "EvenQ"}]], "\[RuleDelayed]", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F[],
      Editable->False], 
     RowBox[{"pow", "/", "2"}]]}]}], "}"}]], "Output",
 CellLabel->
  "Out[31]=",ExpressionUUID->"134d8139-3b56-4ece-9114-5f798c42c888"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definition of the conformal relation", \
"Subsubsection",ExpressionUUID->"71f21e26-ba8e-48c5-851d-96ee75721a7d"],

Cell[TextData[{
 "The metric g is in our mind the Jordan frame one, and the metric \
conformally related ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["gsqrtF2", "\[Mu]\[Nu]"], "=", 
    RowBox[{
     RowBox[{"F", "[", "\[CurlyPhi]", "]"}], " ", 
     SubscriptBox["g", "\[Mu]\[Nu]"]}]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "812f7302-289d-45a9-9212-96719703acb8"],
 " is the Einstein frame one"
}], "Text",ExpressionUUID->"ee85e0a9-2b2b-4042-ad28-ae4c95ccb8ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DefConformalMetric"}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"20a5b92e-fc7a-4399-8ed8-aa271d12653e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefConformalMetric[g,S] defines a metric \
conformally related to 'g', with the conformal factor 'S'. If other metrics \
are conformally related to 'g', then 'gS2' is related to them by transitivity \
of the conformal transformation. If the scalar field S[] does not exist, it \
is defined.\\n   Options are PrintAs->printasform, \
ConformalMetricName->MetricName, FrameColor->somecolor and \
SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no ConformalMetricName is \
provided the name chosen is the concatenation 'metric+conformalfactor+2'. If \
no color is provided, it choses randomly a color. If no SymbolOfCovD is \
provided, the combination {:,\[Del]metricname} is chosen.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "argm"}], 
                    "MessageName"], ",", "DefConformalMetric", ",", "0", ",", 
                    "2"}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`g_", "?", "MetricQ"}], ",", 
                    "xAct`xConf`Private`conffactor_", ",", 
                    RowBox[{"xAct`xConf`Private`options", ":", 
                    RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`nmetlist", ",", 
                    "xAct`xConf`Private`pas", ",", 
                    "xAct`xConf`Private`gconfnameraw", ",", 
                    "xAct`xConf`Private`cdgconf", ",", 
                    "xAct`xConf`Private`metlist", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "xAct`xConf`Private`symbolscovd"}], "}"}], ",", 
                    RowBox[{"Catch", "[", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`M", "=", 
                    RowBox[{"ManifoldOfCovD", "[", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}], "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`CD", "=", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}]}]}], "}"}], ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`i1", "=", 
                    RowBox[{"DummyIn", "[", 
                    RowBox[{"Tangent", "[", "xAct`xConf`Private`M", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`i2", "=", 
                    RowBox[{"DummyIn", "[", 
                    RowBox[{"Tangent", "[", "xAct`xConf`Private`M", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`sy1", "=", 
                    RowBox[{
                    
                    RowBox[{"SymbolOfCovD", "[", "xAct`xConf`Private`CD", 
                    "]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`sy2", "=", 
                    RowBox[{
                    
                    RowBox[{"SymbolOfCovD", "[", "xAct`xConf`Private`CD", 
                    "]"}], "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`metlist", "=", "$Metrics"}], 
                    ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`pas", ",", 
                    "xAct`xConf`Private`gconfnameraw", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "xAct`xConf`Private`symbolscovd"}], "}"}], "=", 
                    RowBox[{"OptionValue", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"PrintAs", ",", "ConformalMetricName", ",", 
                    "FrameColor", ",", "SymbolOfCovD"}], "}"}], "]"}]}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`gconfnameraw", "===", 
                    "Automatic"}], ",", 
                    RowBox[{"xAct`xConf`Private`gconfnameraw", "=", 
                    RowBox[{"ConformalMetricName", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`conffactor"}], "]"}]}]}], "]"}], ";", 
                    
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", "=", 
                    "xAct`xConf`Private`gconfnameraw"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`cdgconf", "=", 
                    RowBox[{"SymbolJoin", "[", 
                    
                    RowBox[{"xAct`xConf`Private`CD", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"MetricQ", "[", "xAct`xConf`Private`gconfname", 
                    "]"}], ",", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "old"}], 
                    "MessageName"], ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`symbolscovd", "\[Equal]", 
                    "Automatic"}], ",", 
                    RowBox[{"xAct`xConf`Private`symbolscovd", "=", 
                    RowBox[{"{", 
                    RowBox[{"\":\"", ",", 
                    RowBox[{"\"\[Del]\"", "<>", 
                    
                    RowBox[{"ToString", "[", "xAct`xConf`Private`gconfname", 
                    "]"}]}]}], "}"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"xTensorQ", "[", "xAct`xConf`Private`gconfname", 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`pas", "===", "Automatic"}], 
                    ",", 
                    RowBox[{"xAct`xConf`Private`pas", "=", 
                    RowBox[{"\"[\"", "<>", 
                    RowBox[{"PrintAs", "[", "xAct`xConf`Private`g", "]"}], 
                    "<>", 
                    RowBox[{"(", 
                    RowBox[{"\"\\!\\(\"", "<>", 
                    
                    RowBox[{"PrintAs", "[", "xAct`xConf`Private`conffactor", 
                    "]"}], "<>", "\"\\^2\\)\""}], ")"}], "<>", "\"]\""}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`color", "===", "Automatic"}], 
                    ",", 
                    RowBox[{"xAct`xConf`Private`color", "=", 
                    RowBox[{"RandomColor", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Choosing color \"", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "\" for this conformal frame.\""}], "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`ColorFrame", "[", 
                    "xAct`xConf`Private`gconfname", "]"}], "=", 
                    "xAct`xConf`Private`color"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"xTensorQ", "[", "xAct`xConf`Private`conffactor", 
                    "]"}]}], ",", 
                    RowBox[{"DefTensor", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], ",", 
                    
                    RowBox[{"{", "xAct`xConf`Private`M", "}"}], ",", 
                    RowBox[{"PrintAs", "\[Rule]", 
                    
                    RowBox[{"ToString", "[", "xAct`xConf`Private`conffactor", 
                    "]"}]}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"Off", "[", 
                    StyleBox[
                    RowBox[{"DefMetric", "::", "old"}], "MessageName"], "]"}],
                     ";", 
                    RowBox[{"DefMetric", "[", 
                    RowBox[{
                    
                    RowBox[{"SignDetOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}], ",", 
                    RowBox[{"xAct`xConf`Private`gconfname", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    "xAct`xConf`Private`cdgconf", ",", 
                    "xAct`xConf`Private`symbolscovd", ",", 
                    RowBox[{"PrintAs", "\[Rule]", "xAct`xConf`Private`pas"}], 
                    ",", 
                    RowBox[{"ConformalTo", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`g", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    SuperscriptBox[
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "2"]}], "}"}]}]}], "]"}], ";", 
                    RowBox[{"DefInertHead", "[", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`gconfname", "]"}], ",", 
                    RowBox[{"ContractThrough", "\[Rule]", 
                    RowBox[{"{", "delta", "}"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"InertHeadQ", "[", 
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g", 
                    "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"DefInertHead", "[", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g", 
                    "]"}], ",", 
                    RowBox[{"ContractThrough", "\[Rule]", 
                    RowBox[{"{", "delta", "}"}]}]}], "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", ",", 
                    "xAct`xConf`Private`g"}], "]"}], "=", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}], "=", 
                    FractionBox["1", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "]"}], ":=", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}], 
                    ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}], ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", ",", 
                    "xAct`xConf`Private`g"}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Catch", "[", 
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], "]"}],
                     "=!=", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"SetConformalTo", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`gconfname", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"ConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    SuperscriptBox[
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "2"]}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`gconfname", ",", "#1"}], 
                    "]"}], "=", 
                    RowBox[{
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}]}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"#1", ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}], "=", 
                    FractionBox["1", 
                    RowBox[{
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}]]}], 
                    ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    RowBox[{"#1", ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}], ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`gconfname", ",", "#1"}], 
                    "]"}], ";"}]}], "]"}], "&"}], ")"}], "/@", 
                    "xAct`xConf`Private`metlist"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}]}]}], "]"}]}], "]"}], "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", "_", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "argr"}], 
                    "MessageName"], ",", "DefConformalMetric", ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}, {
                   " "}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   PaneSelectorBox[{True->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    False),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"], False->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    True),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]]], 
                   PaneSelectorBox[{True->GridBox[{
                    {
                    RowBox[{"PrintAs", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"ConformalMetricName", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"FrameColor", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"SymbolOfCovD", "\[Rule]", "Automatic"}]},
                    {
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "4", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{1.}}}], False->
                    RowBox[{
                    RowBox[{"PrintAs", "\[Rule]", "Automatic"}], 
                    "\[ThinSpace]", 
                    StyleBox["\<\"\[Ellipsis]\"\>", "InformationRowOpener",
                    StripOnInput->False], "\[ThinSpace]", 
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "4", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]],
                    BaselinePosition->Baseline,
                    ImageSize->Automatic]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xConf`DefConformalMetric\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefConformalMetric[g,S] defines a metric \
conformally related to 'g', with the conformal factor 'S'. If other metrics \
are conformally related to 'g', then 'gS2' is related to them by transitivity \
of the conformal transformation. If the scalar field S[] does not exist, it \
is defined.\\n   Options are PrintAs->printasform, \
ConformalMetricName->MetricName, FrameColor->somecolor and \
SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no ConformalMetricName is \
provided the name chosen is the concatenation 'metric+conformalfactor+2'. If \
no color is provided, it choses randomly a color. If no SymbolOfCovD is \
provided, the combination {:,\[Del]metricname} is chosen.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {3., 7.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {3., 7.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DefConformalMetric[g,S] defines a metric conformally related to 'g', \
with the conformal factor 'S'. If other metrics are conformally related to \
'g', then 'gS2' is related to them by transitivity of the conformal \
transformation. If the scalar field S[] does not exist, it is defined.\n   \
Options are PrintAs->printasform, ConformalMetricName->MetricName, \
FrameColor->somecolor and SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no \
ConformalMetricName is provided the name chosen is the concatenation \
'metric+conformalfactor+2'. If no color is provided, it choses randomly a \
color. If no SymbolOfCovD is provided, the combination {:,\[Del]metricname} \
is chosen.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None,
     "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xConf`DefConformalMetric, {
      xAct`xConf`DefConformalMetric[] :> Message[
         MessageName[xAct`xConf`DefConformalMetric, "argm"], 
         xAct`xConf`DefConformalMetric, 0, 2], xAct`xConf`DefConformalMetric[
         PatternTest[
          Pattern[xAct`xConf`Private`g, 
           Blank[]], xAct`xTensor`MetricQ], 
         Pattern[xAct`xConf`Private`conffactor, 
          Blank[]], 
         Pattern[xAct`xConf`Private`options, 
          OptionsPattern[]]] :> 
       Module[{xAct`xConf`Private`nmetlist, xAct`xConf`Private`pas, 
          xAct`xConf`Private`gconfnameraw, xAct`xConf`Private`cdgconf, 
          xAct`xConf`Private`metlist, xAct`xConf`Private`color, 
          xAct`xConf`Private`symbolscovd}, 
         Catch[
          With[{xAct`xConf`Private`M = xAct`xTensor`ManifoldOfCovD[
              xAct`xTensor`CovDOfMetric[xAct`xConf`Private`g]], 
            xAct`xConf`Private`CD = 
            xAct`xTensor`CovDOfMetric[xAct`xConf`Private`g]}, 
           With[{xAct`xConf`Private`i1 = xAct`xTensor`DummyIn[
               xAct`xTensor`Tangent[xAct`xConf`Private`M]], 
             xAct`xConf`Private`i2 = xAct`xTensor`DummyIn[
               xAct`xTensor`Tangent[xAct`xConf`Private`M]], 
             xAct`xConf`Private`sy1 = Part[
               xAct`xTensor`SymbolOfCovD[xAct`xConf`Private`CD], 1], 
             xAct`xConf`Private`sy2 = Part[
               xAct`xTensor`SymbolOfCovD[xAct`xConf`Private`CD], 2]}, 
            xAct`xConf`Private`metlist = 
             xAct`xTensor`$Metrics; {
              xAct`xConf`Private`pas, xAct`xConf`Private`gconfnameraw, 
               xAct`xConf`Private`color, xAct`xConf`Private`symbolscovd} = 
             OptionValue[{
               xAct`xTensor`PrintAs, xAct`xConf`ConformalMetricName, 
                xAct`xConf`FrameColor, xAct`xTensor`SymbolOfCovD}]; 
            If[xAct`xConf`Private`gconfnameraw === Automatic, 
              xAct`xConf`Private`gconfnameraw = 
              xAct`xConf`ConformalMetricName[
               xAct`xConf`Private`g, xAct`xConf`Private`conffactor]]; 
            With[{xAct`xConf`Private`gconfname = 
               xAct`xConf`Private`gconfnameraw}, 
              xAct`xConf`Private`cdgconf = 
               xAct`xCore`SymbolJoin[
                xAct`xConf`Private`CD, xAct`xConf`Private`gconfname]; If[
                xAct`xTensor`MetricQ[xAct`xConf`Private`gconfname], 
                Message[
                 MessageName[xAct`xConf`DefConformalMetric, "old"], 
                 xAct`xConf`Private`gconfname]]; 
              If[xAct`xConf`Private`symbolscovd == Automatic, 
                xAct`xConf`Private`symbolscovd = {
                 ":", "\[Del]" <> ToString[xAct`xConf`Private`gconfname]}]; If[
                Not[
                 xAct`xTensor`xTensorQ[xAct`xConf`Private`gconfname]], 
                If[xAct`xConf`Private`pas === Automatic, 
                  xAct`xConf`Private`pas = (("[" <> 
                    xAct`xTensor`PrintAs[xAct`xConf`Private`g]) <> (("\!\(" <> 
                    xAct`xTensor`PrintAs[xAct`xConf`Private`conffactor]) <> 
                    "\^2\)")) <> "]"]; 
                If[xAct`xConf`Private`color === Automatic, 
                  xAct`xConf`Private`color = RandomColor[]]; 
                Print["Choosing color ", xAct`xConf`Private`color, 
                  " for this conformal frame."]; 
                xAct`xConf`Private`ColorFrame[xAct`xConf`Private`gconfname] = 
                 xAct`xConf`Private`color; If[
                  Not[
                   xAct`xTensor`xTensorQ[xAct`xConf`Private`conffactor]], 
                  xAct`xTensor`DefTensor[
                   xAct`xConf`Private`conffactor[], {xAct`xConf`Private`M}, 
                   xAct`xTensor`PrintAs -> 
                   ToString[xAct`xConf`Private`conffactor]]]; Off[
                  MessageName[xAct`xTensor`DefMetric, "old"]]; 
                xAct`xTensor`DefMetric[
                  xAct`xTensor`SignDetOfMetric[xAct`xConf`Private`g], 
                  
                  xAct`xConf`Private`gconfname[-xAct`xConf`Private`i1, -
                   xAct`xConf`Private`i2], xAct`xConf`Private`cdgconf, 
                  xAct`xConf`Private`symbolscovd, xAct`xTensor`PrintAs -> 
                  xAct`xConf`Private`pas, xAct`xTensor`ConformalTo -> {
                    
                    xAct`xConf`Private`g[-xAct`xConf`Private`i1, -
                    xAct`xConf`Private`i2], 
                    xAct`xConf`Private`conffactor[]^2}]; 
                xAct`xTensor`DefInertHead[
                  xAct`xConf`ConformalFrame[xAct`xConf`Private`gconfname], 
                  xAct`xTensor`ContractThrough -> {xAct`xTensor`delta}]; If[
                  Not[
                   xAct`xTensor`InertHeadQ[
                    xAct`xConf`ConformalFrame[xAct`xConf`Private`g]]], 
                  xAct`xTensor`DefInertHead[
                    xAct`xConf`ConformalFrame[xAct`xConf`Private`g], 
                    xAct`xTensor`ContractThrough -> {xAct`xTensor`delta}]; 
                  Null]; TagSet[xAct`xConf`Private`gconfname, 
                  xAct`xConf`SqrtConformalFactor[
                  xAct`xConf`Private`gconfname, xAct`xConf`Private`g], 
                  xAct`xConf`Private`conffactor[]]; 
                TagSet[xAct`xConf`Private`gconfname, 
                  xAct`xConf`SqrtConformalFactor[
                  xAct`xConf`Private`g, xAct`xConf`Private`gconfname], 1/
                  xAct`xConf`Private`conffactor[]]; 
                xAct`xConf`ConformalFrame[
                   Blank[]][
                   xAct`xConf`Private`conffactor[]] := 
                 xAct`xConf`Private`conffactor[]; 
                xAct`xConf`RulesChangeConformalFrame[
                 xAct`xConf`Private`g, xAct`xConf`Private`gconfname]; 
                xAct`xConf`RulesChangeConformalFrame[
                 xAct`xConf`Private`gconfname, xAct`xConf`Private`g]; 
                Map[If[Catch[
                    xAct`xTensor`ConformalRules[
                    xAct`xConf`Private`g, #]] =!= {}, 
                   xAct`xTensor`SetConformalTo[
                    
                    xAct`xConf`Private`gconfname[-xAct`xConf`Private`i1, -
                    xAct`xConf`Private`i2], {
                    #[-xAct`xConf`Private`i1, -xAct`xConf`Private`i2], 
                    xAct`xTensor`ConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[]^2}]; 
                   TagSet[xAct`xConf`Private`gconfname, 
                    xAct`xConf`SqrtConformalFactor[
                    xAct`xConf`Private`gconfname, #], 
                    xAct`xConf`SqrtConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[]]; 
                   TagSet[xAct`xConf`Private`gconfname, 
                    
                    xAct`xConf`SqrtConformalFactor[#, 
                    xAct`xConf`Private`gconfname], 1/(
                    xAct`xConf`SqrtConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[])]; 
                   xAct`xConf`RulesChangeConformalFrame[#, 
                    xAct`xConf`Private`gconfname]; 
                   xAct`xConf`RulesChangeConformalFrame[
                    xAct`xConf`Private`gconfname, #]; Null]& , 
                  xAct`xConf`Private`metlist]; Null]; Null]]]]], 
       xAct`xConf`DefConformalMetric[
         Blank[]] :> Message[
         MessageName[xAct`xConf`DefConformalMetric, "argr"], 
         xAct`xConf`DefConformalMetric, {2, 
          DirectedInfinity[1]}]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {
     xAct`xTensor`PrintAs -> Automatic, xAct`xConf`ConformalMetricName -> 
      Automatic, xAct`xConf`FrameColor -> Automatic, 
      xAct`xTensor`SymbolOfCovD -> Automatic}, "Attributes" -> {Protected}, 
    "FullName" -> "xAct`xConf`DefConformalMetric"|>, False]]], "Output",
 CellLabel->
  "Out[14]=",ExpressionUUID->"8016954a-206b-4120-89d7-1cd792a117fe"]
}, Open  ]],

Cell["\<\
We use the red color to print the conformal frame and the covariant \
derivative of the conformally related metric\
\>", "Text",ExpressionUUID->"639e091c-1de0-4365-98ba-bfe79ad74ffd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConformalMetric", "[", 
  RowBox[{"g", ",", "sqrtF", ",", 
   RowBox[{"PrintAs", "->", "\"\<gF\>\""}], ",", 
   RowBox[{"SymbolOfCovD", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\":\",FontColor->RGBColor[1, 0, 0]]\)\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"\[Del]\",FontColor->RGBColor[1, 0, 0]]\)\>\""}], 
     "}"}]}], ",", 
   RowBox[{"ConformalMetricName", "->", "gF"}], ",", 
   RowBox[{"FrameColor", "->", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"41058d1a-8413-48d9-9fb6-0e96c62beb62"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Choosing color \"\>", "\[InvisibleSpace]", 
   TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>,
    "RGBColorSwatchTemplate"], 
   "\[InvisibleSpace]", "\<\" for this conformal frame.\"\>"}],
  SequenceForm["Choosing color ", 
   RGBColor[1, 0, 0], " for this conformal frame."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"20851166-3594-4cd1-a084-dbf7c89b752e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"gF", "[", 
    RowBox[{
     RowBox[{"-", "\[Sigma]$5860"}], ",", 
     RowBox[{"-", "\[Sigma]$5861"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`gF[-$CellContext`\[Sigma]$5860, -$CellContext`\[Sigma]$5861], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7c935911-f51b-430d-add8-0d029a4bda54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"InvgF", "[", 
    RowBox[{"\[Sigma]$5860", ",", "\[Sigma]$5861"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`InvgF[$CellContext`\[Sigma]$5860, $CellContext`\[Sigma]$5861],
    ". ", "Metric is frozen!"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"9bbec9ff-1be4-4656-97fb-50f19f3ba59e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongF", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilongF[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"55d4f46e-b784-427e-83f8-5b1846e90a7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragF", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragF[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"1399e402-e52f-42ae-94cf-050da6287f96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragF\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragF\[Dagger][-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"67887417-19b0-45e3-a56a-867e1f4cd922"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDgF", "[", 
    RowBox[{"-", "\[Sigma]$5860"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDgF[-$CellContext`\[Sigma]$5860], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"998ef219-5eeb-41cc-bbee-50087194fb33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCDgF", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCDgF[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"bb55fd92-a4cf-4717-ada6-59cd8dac8cfa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgF", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDgF[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"df96e6ea-81ae-4721-bba1-c38e3fcdd972"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCDgF", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCDgF[-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"27f7c38e-7c22-46eb-aee9-0abccd35dcec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDgF", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", "\[Lambda]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDgF[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], $CellContext`\[Lambda]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"de72ccc4-e58f-4e58-8c1d-0550794cef49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDgF", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCDgF[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8be2759c-d000-45fd-ae43-49476c71836c"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4f7d354a-0496-4958-96e5-71c960e74aa4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDgF", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDgF[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"d1ccea51-9486-4ddd-bf7b-a2d4e1bdcb36"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"8390751d-63cd-4377-a95f-cf7f27a4ba1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDgF", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCDgF[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"abc82829-a54c-4356-b075-0172f581c79b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDgF", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCDgF[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"45c34d5f-1253-47f3-90db-13994dc66c8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDgF", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDgF[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"f1467805-fed5-4bab-8ccc-1470c4a0d685"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDgF", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDgF[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"4c95b622-e2e7-4f54-8303-e9c51d029489"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"59e4d25d-fa58-4f7c-93d3-ba88c1957ff7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"53eefa05-032d-4b94-9a0d-5794fef14711"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetgF", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetgF[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"79ea6c9b-d3f7-4f29-b115-e77e187347a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "gF", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`gF], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"3aaac7f5-9112-479e-8cee-47806ebcfcc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "g", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`g], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"7d0fca91-a976-4eb4-be25-53ac87626349"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lagrangian of the theory", \
"Subsubsection",ExpressionUUID->"e22885c5-82df-4ea8-b2b2-3fbc65bb19a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", "\[Kappa]", "]"}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"55fe9523-4cbe-4a1d-ba5a-fdc1016062d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "\[Kappa]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", 
   "constant symbol ", $CellContext`\[Kappa], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"4d4b844c-3e8b-456a-8fb2-e221cf2f4413"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"LMatterJ", "[", "]"}], ",", "M", ",", 
   RowBox[{
   "PrintAs", "->", 
    "\"\<\!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(M\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"49223864-845e-42b4-913b-67131b6db022"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"LMatterJ", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`LMatterJ[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"c6926688-a09b-4830-aa4c-8765e7d6b7fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LGravJordan", " ", "=", 
  RowBox[{
   RowBox[{"(", " ", 
    RowBox[{
     RowBox[{"F", "[", "]"}], 
     RowBox[{"RicciScalarCD", "[", "]"}]}], ")"}], 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"Detg", "[", "]"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "\[Kappa]"}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"LFieldJordan", " ", "=", 
  RowBox[{
   RowBox[{"(", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], " ", 
      RowBox[{
       RowBox[{"CD", "[", "\[Alpha]", "]"}], "[", 
       RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "\[Alpha]"}], "]"}], "[", 
       RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}]}], "-", 
     RowBox[{"VJ", "[", 
      RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}]}], ")"}], 
   RowBox[{"Sqrt", "[", 
    RowBox[{"Detg", "[", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"LMatterJordan", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Detg", "[", "]"}], "]"}], 
   RowBox[{"LMatterJ", "[", "]"}]}]}]}], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"db2941ea-f0a1-4cc9-ba46-6537dae2f7bf"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox["F",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`F[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[Del]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False]}], 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False]}]]], "Output",
 CellLabel->"Out[22]=",ExpressionUUID->"cf4b5d4e-af7a-444b-b2d5-fba28af40811"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   InterpretationBox[
    StyleBox[
     OverscriptBox["g", 
      OverscriptBox[
       StyleBox["~",
        FontColor->RGBColor[0, 0, 0]], 
       StyleBox["~",
        FontColor->RGBColor[0, 0, 0]]]],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Detg[],
    Editable->False]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["V", "J"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`VJ,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`\[CurlyPhi][]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[$CellContext`\[Alpha]][
       $CellContext`\[CurlyPhi][]],
      Editable->False]}]}], ")"}]}]], "Output",
 CellLabel->"Out[23]=",ExpressionUUID->"65010f0d-9691-44ae-8a8d-3e95010b40d8"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   InterpretationBox[
    StyleBox[
     OverscriptBox["g", 
      OverscriptBox[
       StyleBox["~",
        FontColor->RGBColor[0, 0, 0]], 
       StyleBox["~",
        FontColor->RGBColor[0, 0, 0]]]],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Detg[],
    Editable->False]], " ", 
  InterpretationBox[
   StyleBox[
    SubscriptBox["\[ScriptCapitalL]", "M"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LMatterJ[],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[24]=",ExpressionUUID->"759d7738-02a3-4a3a-971c-e1cac52ebe43"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformation from Jordan frame to Einstein frame", \
"Section",ExpressionUUID->"28ba5083-5630-46c0-97f9-d203831a3fd7"],

Cell["\<\
We used a pure scalar for the conformal transformation (because this is what \
xConf needs), but we then replace it by F(\[CurlyPhi]), which is the (square \
of) the conformal factor between Einstein and Jordan frames.\
\>", "Text",ExpressionUUID->"49582ac4-b81e-4d5c-a523-f4fb269489df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RuleF\[CurlyPhi]", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"F", "[", "]"}], ":>", 
    RowBox[{"Fof\[CurlyPhi]", "[", 
     RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"3db2b59c-7048-46a8-a375-980149e8a54c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox["F",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`F[],
    Editable->False], "\[RuleDelayed]", 
   RowBox[{
    InterpretationBox[
     StyleBox["F",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Fof\[CurlyPhi],
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}]}], "}"}]], "Output",
 CellLabel->
  "Out[25]=",ExpressionUUID->"72281812-0459-484b-9f26-debc5129fed6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ToMetric", "[", "gF", "]"}], "[", 
    RowBox[{"LGravJordan", "+", "LFieldJordan", "+", "LMatterJordan"}], "]"}],
    "/.", "RulesqrtF"}], "/.", "RuleF\[CurlyPhi]"}], "\[IndentingNewLine]", 
 RowBox[{"ActionDensity", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"%", "//", "NoScalar"}], "//", "Simplify"}], "//", 
   "Expand"}]}]}], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"5a225840-07ac-4a56-b625-3276333d7b8b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False], 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}], "4"]]], " ", 
   InterpretationBox[
    StyleBox[
     SubscriptBox["\[ScriptCapitalL]", "M"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LMatterJ[],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox[
      InterpretationBox[
       StyleBox[
        OverscriptBox["gF", 
         OverscriptBox[
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]], 
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`DetgF[],
       Editable->False], 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["F",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Fof\[CurlyPhi],
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["\[CurlyPhi]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[CurlyPhi][],
         Editable->False], "]"}], "4"]]], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", 
       StyleBox["\[Del]",
        FontColor->RGBColor[1, 0, 0]], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCDgF[],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False], 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}], "4"]]], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["F",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Fof\[CurlyPhi],
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"igF", 
            StyleBox[GridBox[{
               {"\[Alpha]", "\[Beta]"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
        Editable->False], " ", 
       RowBox[{"(", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox[
            StyleBox["\[Del]",
             FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[CurlyPhi]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CDgF[-$CellContext`\[Alpha]][
          $CellContext`\[CurlyPhi][]],
         Editable->False], ")"}], " ", 
       RowBox[{"(", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox[
            StyleBox["\[Del]",
             FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[CurlyPhi]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CDgF[-$CellContext`\[Beta]][
          $CellContext`\[CurlyPhi][]],
         Editable->False], ")"}]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[$CellContext`InvgF[$CellContext`\[Alpha], \
$CellContext`\[Beta]] $CellContext`CDgF[-$CellContext`\[Alpha]][
       $CellContext`\[CurlyPhi][]] $CellContext`CDgF[-$CellContext`\[Beta]][
       $CellContext`\[CurlyPhi][]]],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     FractionBox[
      InterpretationBox[
       StyleBox[
        OverscriptBox["gF", 
         OverscriptBox[
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]], 
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`DetgF[],
       Editable->False], 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["F",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Fof\[CurlyPhi],
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["\[CurlyPhi]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[CurlyPhi][],
         Editable->False], "]"}], "4"]]], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], 
     RowBox[{"3", "/", "2"}]], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"igF", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              InterpretationBox[
               StyleBox[
                RowBox[{
                 SubscriptBox[
                  StyleBox["\[Del]",
                   FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[CurlyPhi]"}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`CDgF[-$CellContext`\[Alpha]][
                $CellContext`\[CurlyPhi][]],
               Editable->False], ")"}], " ", 
             RowBox[{"(", 
              InterpretationBox[
               StyleBox[
                RowBox[{
                 SubscriptBox[
                  StyleBox["\[Del]",
                   FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[CurlyPhi]"}],
                
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`CDgF[-$CellContext`\[Beta]][
                $CellContext`\[CurlyPhi][]],
               Editable->False], ")"}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["F",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`Fof\[CurlyPhi],
                 Editable->False], "\[Prime]",
                MultilineFunction->None], "[", 
               InterpretationBox[
                StyleBox["\[CurlyPhi]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[CurlyPhi][],
                Editable->False], "]"}], "2"]}], 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{
               InterpretationBox[
                StyleBox["F",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Fof\[CurlyPhi],
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["\[CurlyPhi]",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`\[CurlyPhi][],
                Editable->False], "]"}], 
              RowBox[{"3", "/", "2"}]]}]]}], "+", 
          FractionBox[
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              InterpretationBox[
               StyleBox[
                RowBox[{
                 SubscriptBox[
                  StyleBox["\[Del]",
                   FontColor->RGBColor[1, 0, 0]], "\[Beta]"], 
                 SubscriptBox[
                  StyleBox["\[Del]",
                   FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[CurlyPhi]"}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`CDgF[-$CellContext`\[Beta]][
                $CellContext`CDgF[-$CellContext`\[Alpha]][
                 $CellContext`\[CurlyPhi][]]],
               Editable->False], ")"}], " ", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["F",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Fof\[CurlyPhi],
                Editable->False], "\[Prime]",
               MultilineFunction->None], "[", 
              InterpretationBox[
               StyleBox["\[CurlyPhi]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[CurlyPhi][],
               Editable->False], "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              InterpretationBox[
               StyleBox[
                RowBox[{
                 SubscriptBox[
                  StyleBox["\[Del]",
                   FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[CurlyPhi]"}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`CDgF[-$CellContext`\[Alpha]][
                $CellContext`\[CurlyPhi][]],
               Editable->False], ")"}], " ", 
             RowBox[{"(", 
              InterpretationBox[
               StyleBox[
                RowBox[{
                 SubscriptBox[
                  StyleBox["\[Del]",
                   FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[CurlyPhi]"}],
                
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`CDgF[-$CellContext`\[Beta]][
                $CellContext`\[CurlyPhi][]],
               Editable->False], ")"}], " ", 
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["F",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`Fof\[CurlyPhi],
                Editable->False], "\[Prime]\[Prime]",
               MultilineFunction->None], "[", 
              InterpretationBox[
               StyleBox["\[CurlyPhi]",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`\[CurlyPhi][],
               Editable->False], "]"}]}]}], 
           SqrtBox[
            RowBox[{
             InterpretationBox[
              StyleBox["F",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`Fof\[CurlyPhi],
              Editable->False], "[", 
             InterpretationBox[
              StyleBox["\[CurlyPhi]",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`\[CurlyPhi][],
              Editable->False], "]"}]]]}], ")"}]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`InvgF[$CellContext`\[Alpha], \
$CellContext`\[Beta]] (Rational[-1, 2] $CellContext`Fof\[CurlyPhi][
           $CellContext`\[CurlyPhi][]]^
         Rational[-3, 2] $CellContext`CDgF[-$CellContext`\[Alpha]][
          $CellContext`\[CurlyPhi][]] $CellContext`CDgF[-$CellContext`\[Beta]][
          $CellContext`\[CurlyPhi][]] 
        Derivative[1][$CellContext`Fof\[CurlyPhi]][
           $CellContext`\[CurlyPhi][]]^2 + $CellContext`Fof\[CurlyPhi][
           $CellContext`\[CurlyPhi][]]^
         Rational[-1, 2] ($CellContext`CDgF[-$CellContext`\[Beta]][
            $CellContext`CDgF[-$CellContext`\[Alpha]][
             $CellContext`\[CurlyPhi][]]] 
          Derivative[1][$CellContext`Fof\[CurlyPhi]][
            $CellContext`\[CurlyPhi][]] + $CellContext`CDgF[-$CellContext`\
\[Alpha]][
            $CellContext`\[CurlyPhi][]] $CellContext`CDgF[-$CellContext`\
\[Beta]][
            $CellContext`\[CurlyPhi][]] 
          Derivative[2][$CellContext`Fof\[CurlyPhi]][
            $CellContext`\[CurlyPhi][]]))],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  RowBox[{
   SqrtBox[
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False], 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}], "4"]]], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["V", "J"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VJ,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}]}], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     FractionBox[
      InterpretationBox[
       StyleBox[
        OverscriptBox["gF", 
         OverscriptBox[
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]], 
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`DetgF[],
       Editable->False], 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["F",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Fof\[CurlyPhi],
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["\[CurlyPhi]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[CurlyPhi][],
         Editable->False], "]"}], "4"]]], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"igF", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             StyleBox["\[Del]",
              FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[CurlyPhi]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CDgF[-$CellContext`\[Alpha]][
           $CellContext`\[CurlyPhi][]],
          Editable->False], ")"}], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             StyleBox["\[Del]",
              FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[CurlyPhi]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CDgF[-$CellContext`\[Beta]][
           $CellContext`\[CurlyPhi][]],
          Editable->False], ")"}]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`InvgF[$CellContext`\[Alpha], \
$CellContext`\[Beta]] $CellContext`CDgF[-$CellContext`\[Alpha]][
        $CellContext`\[CurlyPhi][]] $CellContext`CDgF[-$CellContext`\[Beta]][
        $CellContext`\[CurlyPhi][]]],
     Editable->False], " ", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "\[Prime]",
       MultilineFunction->None], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]]}]], "Output",
 CellLabel->"Out[32]=",ExpressionUUID->"79b59f9d-d6ac-4ea8-864a-9f5a4662006a"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[ScriptCapitalL]", "M"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LMatterJ[],
     Editable->False]}], 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], "2"]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", 
       StyleBox["\[Del]",
        FontColor->RGBColor[1, 0, 0]], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCDgF[],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubscriptBox["V", "J"],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`VJ,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], "2"]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"igF", 
         StyleBox[GridBox[{
            {"\[Sigma]$11025", "\[Sigma]$11026"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgF[$CellContext`\[Sigma]$11025, \
$CellContext`\[Sigma]$11026],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Sigma]$11025"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Sigma]$11025][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Sigma]$11026"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Sigma]$11026][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}]}], 
   RowBox[{"2", " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"igF", 
         StyleBox[GridBox[{
            {"\[Sigma]$11027", "\[Sigma]$11028"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgF[$CellContext`\[Sigma]$11027, \
$CellContext`\[Sigma]$11028],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Sigma]$11028"], 
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Sigma]$11027"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Sigma]$11028][
       $CellContext`CDgF[-$CellContext`\[Sigma]$11027][
        $CellContext`\[CurlyPhi][]]],
      Editable->False], ")"}], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"igF", 
         StyleBox[GridBox[{
            {"\[Sigma]$11027", "\[Sigma]$11028"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgF[$CellContext`\[Sigma]$11027, \
$CellContext`\[Sigma]$11028],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Sigma]$11027"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Sigma]$11027][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Sigma]$11028"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Sigma]$11028][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "\[Prime]",
       MultilineFunction->None], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}], 
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"igF", 
         StyleBox[GridBox[{
            {"\[Sigma]$11029", "\[Sigma]$11030"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgF[$CellContext`\[Sigma]$11029, \
$CellContext`\[Sigma]$11030],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Sigma]$11029"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Sigma]$11029][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Sigma]$11030"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Sigma]$11030][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "\[Prime]",
       MultilineFunction->None], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"igF", 
         StyleBox[GridBox[{
            {"\[Sigma]$11027", "\[Sigma]$11028"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgF[$CellContext`\[Sigma]$11027, \
$CellContext`\[Sigma]$11028],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Sigma]$11027"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Sigma]$11027][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Sigma]$11028"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Sigma]$11028][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "\[Prime]\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}]]}]], "Output",
 CellLabel->
  "Out[33]=",ExpressionUUID->"8027cead-fdf8-4d43-b5ea-8ffc222405ee"]
}, Open  ]],

Cell["Let us remove a total divergence", \
"Text",ExpressionUUID->"00f0b848-7f6d-441d-be88-ef3b130ce6ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TotalDerivativeEinstein", "=", 
  RowBox[{"ToCanonical", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "\[Kappa]"}], ")"}]}], " ", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"DetgF", "[", "]"}], "]"}], 
    RowBox[{
     RowBox[{"CDgF", "[", 
      RowBox[{"-", "\[Alpha]"}], "]"}], "[", 
     RowBox[{
      RowBox[{"InvgF", "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], 
      RowBox[{
       RowBox[{"CDgF", "[", 
        RowBox[{"-", "\[Beta]"}], "]"}], "[", 
       RowBox[{"Log", "[", 
        RowBox[{"Fof\[CurlyPhi]", "[", 
         RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], "]"}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"321fb7ab-facd-4d30-95fb-e954fd8c7d9f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"3", " ", 
     SqrtBox[
      InterpretationBox[
       StyleBox[
        OverscriptBox["gF", 
         OverscriptBox[
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]], 
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`DetgF[],
       Editable->False]], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"igF", 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox[
          StyleBox["\[Del]",
           FontColor->RGBColor[1, 0, 0]], "\[Beta]"], 
         SubscriptBox[
          StyleBox["\[Del]",
           FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[CurlyPhi]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDgF[-$CellContext`\[Beta]][
        $CellContext`CDgF[-$CellContext`\[Alpha]][
         $CellContext`\[CurlyPhi][]]],
       Editable->False], ")"}], " ", 
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "\[Prime]",
       MultilineFunction->None], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}]}], 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox["\[Kappa]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Kappa],
      Editable->False], " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}]}]]}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"igF", 
         StyleBox[GridBox[{
            {"\[Alpha]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Alpha]][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Beta]][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "\[Prime]",
       MultilineFunction->None], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"igF", 
         StyleBox[GridBox[{
            {"\[Alpha]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Alpha]][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Beta]][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "\[Prime]\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}]]}]], "Output",
 CellLabel->
  "Out[48]=",ExpressionUUID->"e83f40a1-5d7f-4cdf-aec5-218bdd942b1a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionDensityModified", " ", "=", 
  RowBox[{"ToCanonical", "[", " ", 
   RowBox[{"ActionDensity", "+", "TotalDerivativeEinstein"}], 
   "]"}]}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"bbd73518-5dbb-461a-863e-ce35a15d5096"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[ScriptCapitalL]", "M"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LMatterJ[],
     Editable->False]}], 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], "2"]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", 
       StyleBox["\[Del]",
        FontColor->RGBColor[1, 0, 0]], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCDgF[],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubscriptBox["V", "J"],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`VJ,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], "2"]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"igF", 
         StyleBox[GridBox[{
            {"\[Alpha]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Alpha]][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Beta]][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}]}], 
   RowBox[{"2", " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"igF", 
         StyleBox[GridBox[{
            {"\[Alpha]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Alpha]][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[Del]",
          FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[CurlyPhi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgF[-$CellContext`\[Beta]][
       $CellContext`\[CurlyPhi][]],
      Editable->False], ")"}], " ", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "\[Prime]",
       MultilineFunction->None], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}], 
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}]]}]], "Output",
 CellLabel->
  "Out[49]=",ExpressionUUID->"cf42156f-d975-4fca-808f-21e112e5ec73"]
}, Open  ]],

Cell["\<\
We define a new scalar field, which is going to be the canonical scalar field \
in Einstein frame\
\>", "Text",ExpressionUUID->"7a1e4e53-3dbb-4706-a08f-3809f2f00f9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"\[Chi]", "[", "]"}], ",", "M"}], "]"}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"2502ed10-d546-46c6-b9c3-c83655500113"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Chi]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Chi][], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[50]:=",ExpressionUUID->"fd4fb1bc-cb0a-4641-ac1b-79e1bb2b5fd1"]
}, Open  ]],

Cell["This is the relation deduced from \[Chi][\[CurlyPhi]] that we need", \
"Text",ExpressionUUID->"0563ecbf-12a3-4338-bbc4-993c7b2b0eaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RuleD\[CurlyPhi]ToD\[Chi]", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"cd_", "?", "CovDQ"}], "[", "i_", "]"}], "[", 
     RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], ":>", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"Fof\[CurlyPhi]", "[", 
           RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"3", "/", 
           RowBox[{"(", 
            RowBox[{"2", " ", "\[Kappa]"}], ")"}]}], 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Fof\[CurlyPhi]", "'"}], "[", 
              RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], ")"}], "^", "2"}], 
           "/", 
           RowBox[{
            RowBox[{"Fof\[CurlyPhi]", "[", 
             RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], "^", "2"}]}]}]}], 
        ")"}], "]"}]}], 
     RowBox[{
      RowBox[{"cd", "[", "i", "]"}], "[", 
      RowBox[{"\[Chi]", "[", "]"}], "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"c567b663-b246-461d-8a27-a85fcd81d6fa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"cd_", "?", "CovDQ"}], "[", "i_", "]"}], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}], "\[RuleDelayed]", 
   FractionBox[
    RowBox[{
     RowBox[{"cd", "[", "i", "]"}], "[", 
     InterpretationBox[
      StyleBox["\[Chi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Chi][],
      Editable->False], "]"}], 
    SqrtBox[
     RowBox[{
      FractionBox["1", 
       RowBox[{
        InterpretationBox[
         StyleBox["F",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Fof\[CurlyPhi],
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["\[CurlyPhi]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[CurlyPhi][],
         Editable->False], "]"}]], "+", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["F",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Fof\[CurlyPhi],
            Editable->False], "\[Prime]",
           MultilineFunction->None], "[", 
          InterpretationBox[
           StyleBox["\[CurlyPhi]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[CurlyPhi][],
           Editable->False], "]"}], "2"]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox["\[Kappa]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Kappa],
           Editable->False]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["F",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Fof\[CurlyPhi],
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[CurlyPhi]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[CurlyPhi][],
           Editable->False], "]"}], "2"]}]]}]]]}], "}"}]], "Output",
 CellLabel->
  "Out[51]=",ExpressionUUID->"2463aaf3-8ffe-4983-a551-6177e4fe0d3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionDensityModifiedIn\[Chi]1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"ActionDensityModified", "/.", "RuleD\[CurlyPhi]ToD\[Chi]"}], 
     ")"}], "//", "Simplify"}], "//", "ToCanonical"}]}]], "Input",
 CellLabel->"In[52]:=",ExpressionUUID->"4e22ab9f-30e1-438d-b766-da876d498572"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[ScriptCapitalL]", "M"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LMatterJ[],
     Editable->False]}], 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], "2"]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", 
       StyleBox["\[Del]",
        FontColor->RGBColor[1, 0, 0]], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCDgF[],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubscriptBox["V", "J"],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`VJ,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], "2"]], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["gF", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`DetgF[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"igF", 
        StyleBox[GridBox[{
           {"\[Alpha]", "\[Beta]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox[
        StyleBox["\[Del]",
         FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDgF[-$CellContext`\[Alpha]][
      $CellContext`\[Chi][]],
     Editable->False], ")"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox[
        StyleBox["\[Del]",
         FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDgF[-$CellContext`\[Beta]][
      $CellContext`\[Chi][]],
     Editable->False], ")"}]}]}]], "Output",
 CellLabel->
  "Out[52]=",ExpressionUUID->"77386d5b-9027-4ab6-bc9b-3df48427608a"]
}, Open  ]],

Cell["\<\
We also define  a new potential in \[Chi] called VE. And now the Lagrangian \
is perfectly canonical in Einstein frame.\
\>", "Text",ExpressionUUID->"0ca80345-11d8-43b5-970f-ab1375c0fc22"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionDensityModifiedIn\[Chi]2", "=", 
  RowBox[{
   RowBox[{"ActionDensityModifiedIn\[Chi]1", "/.", 
    RowBox[{
     RowBox[{"VJ", "[", 
      RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], ":>", 
     RowBox[{
      RowBox[{"VE", "[", 
       RowBox[{"\[Chi]", "[", "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"Fof\[CurlyPhi]", "[", 
        RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], "^", "2"}]}]}]}], "/.", 
   RowBox[{
    RowBox[{"Fof\[CurlyPhi]", "[", 
     RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], "->", 
    RowBox[{"Fof\[Chi]", "[", 
     RowBox[{"\[Chi]", "[", "]"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"ebcf8833-8dcb-4f33-b719-f48d3037b955"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[ScriptCapitalL]", "M"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LMatterJ[],
     Editable->False]}], 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[Chi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[Chi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Chi][],
      Editable->False], "]"}], "2"]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gF", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgF[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", 
       StyleBox["\[Del]",
        FontColor->RGBColor[1, 0, 0]], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCDgF[],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["gF", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`DetgF[],
     Editable->False]], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["V", "E"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VE,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Chi][],
     Editable->False], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["gF", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`DetgF[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"igF", 
        StyleBox[GridBox[{
           {"\[Alpha]", "\[Beta]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox[
        StyleBox["\[Del]",
         FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDgF[-$CellContext`\[Alpha]][
      $CellContext`\[Chi][]],
     Editable->False], ")"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox[
        StyleBox["\[Del]",
         FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDgF[-$CellContext`\[Beta]][
      $CellContext`\[Chi][]],
     Editable->False], ")"}]}]}]], "Output",
 CellLabel->
  "Out[53]=",ExpressionUUID->"df473882-1928-4c45-85f7-d7818f66962b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformation from Einstein frame to Jordan frame", \
"Section",ExpressionUUID->"029d90da-16ba-4298-b1a3-0020055602b9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LGravEinstein", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"DetgF", "[", "]"}], "]"}], 
   RowBox[{
    RowBox[{"RicciScalarCDgF", "[", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "\[Kappa]"}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"LFieldEinstein", "=", " ", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"DetgF", "[", "]"}], "]"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], " ", 
      RowBox[{"InvgF", "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], 
      RowBox[{
       RowBox[{"CDgF", "[", 
        RowBox[{"-", "\[Alpha]"}], "]"}], "[", 
       RowBox[{"\[Chi]", "[", "]"}], "]"}], 
      RowBox[{
       RowBox[{"CDgF", "[", 
        RowBox[{"-", "\[Beta]"}], "]"}], "[", 
       RowBox[{"\[Chi]", "[", "]"}], "]"}]}], "-", 
     RowBox[{"VE", "[", 
      RowBox[{"\[Chi]", "[", "]"}], "]"}]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"LMatterEinstein", "=", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"DetgF", "[", "]"}], "]"}], 
   RowBox[{
    RowBox[{"LMatterJ", "[", "]"}], "/", 
    RowBox[{
     RowBox[{"Fof\[Chi]", "[", 
      RowBox[{"\[Chi]", "[", "]"}], "]"}], "^", "2"}]}]}]}]}], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"63776d1e-3e9b-4b9c-9e06-6a4e414e2d13"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["gF", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`DetgF[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", 
      StyleBox["\[Del]",
       FontColor->RGBColor[1, 0, 0]], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCDgF[],
    Editable->False]}], 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False]}]]], "Output",
 CellLabel->"Out[54]=",ExpressionUUID->"56ccbddb-cf50-4446-958a-a8d3596c2949"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   InterpretationBox[
    StyleBox[
     OverscriptBox["gF", 
      OverscriptBox[
       StyleBox["~",
        FontColor->RGBColor[0, 0, 0]], 
       StyleBox["~",
        FontColor->RGBColor[0, 0, 0]]]],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`DetgF[],
    Editable->False]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["V", "E"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`VE,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[Chi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Chi][],
       Editable->False], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"igF", 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`InvgF[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox[
          StyleBox["\[Del]",
           FontColor->RGBColor[1, 0, 0]], "\[Alpha]"], "\[Chi]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDgF[-$CellContext`\[Alpha]][
        $CellContext`\[Chi][]],
       Editable->False], ")"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox[
          StyleBox["\[Del]",
           FontColor->RGBColor[1, 0, 0]], "\[Beta]"], "\[Chi]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDgF[-$CellContext`\[Beta]][
        $CellContext`\[Chi][]],
       Editable->False], ")"}]}]}], ")"}]}]], "Output",
 CellLabel->"Out[55]=",ExpressionUUID->"f827a4e9-3c12-4637-bf06-a474fa04bc6e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["gF", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`DetgF[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[
     SubscriptBox["\[ScriptCapitalL]", "M"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LMatterJ[],
    Editable->False]}], 
  SuperscriptBox[
   RowBox[{
    InterpretationBox[
     StyleBox["F",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Fof\[Chi],
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Chi][],
     Editable->False], "]"}], "2"]]], "Output",
 CellLabel->
  "Out[56]=",ExpressionUUID->"0d3f2189-7634-43d4-bb2c-102be7a4ab08"]
}, Open  ]],

Cell["\<\
We check that this is indeed what we had found from expressing the Jordan \
frame into the Einstein frame earlier M\
\>", "Text",ExpressionUUID->"7b12644d-0fa1-46f5-86de-4a407a8a3ea6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ActionDensityModifiedIn\[Chi]2", "-", 
   RowBox[{"(", 
    RowBox[{"LGravEinstein", "+", "LFieldEinstein", "+", "LMatterEinstein"}], 
    ")"}]}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"8c3c3e92-890b-47d6-b149-0c935daadb9c"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[57]=",ExpressionUUID->"9a7db164-c548-4633-99d3-e394ef329d67"]
}, Open  ]],

Cell["\<\
This is the rule we are going to need, which is based on the \[Chi](\
\[CurlyPhi]) relation.\
\>", "Text",ExpressionUUID->"6887bd69-5a90-49e9-87ea-d1717a54d624"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RuleD\[Chi]ToD\[CurlyPhi]", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"cd_", "?", "CovDQ"}], "[", "i_", "]"}], "[", 
     RowBox[{"\[Chi]", "[", "]"}], "]"}], ":>", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Fof\[CurlyPhi]", "[", 
          RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"3", "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[Kappa]"}], ")"}]}], 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Fof\[CurlyPhi]", "'"}], "[", 
             RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], ")"}], "^", "2"}], "/", 
          RowBox[{
           RowBox[{"Fof\[CurlyPhi]", "[", 
            RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], "^", "2"}]}]}]}], ")"}],
       "]"}], 
     RowBox[{
      RowBox[{"cd", "[", "i", "]"}], "[", 
      RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[59]:=",ExpressionUUID->"0b7700c2-8e72-46af-b77b-238ca5db1f42"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"cd_", "?", "CovDQ"}], "[", "i_", "]"}], "[", 
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Chi][],
     Editable->False], "]"}], "\[RuleDelayed]", 
   RowBox[{
    SqrtBox[
     RowBox[{
      FractionBox["1", 
       RowBox[{
        InterpretationBox[
         StyleBox["F",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Fof\[CurlyPhi],
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["\[CurlyPhi]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[CurlyPhi][],
         Editable->False], "]"}]], "+", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["F",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Fof\[CurlyPhi],
            Editable->False], "\[Prime]",
           MultilineFunction->None], "[", 
          InterpretationBox[
           StyleBox["\[CurlyPhi]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[CurlyPhi][],
           Editable->False], "]"}], "2"]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox["\[Kappa]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Kappa],
           Editable->False]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["F",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`Fof\[CurlyPhi],
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[CurlyPhi]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[CurlyPhi][],
           Editable->False], "]"}], "2"]}]]}]], " ", 
    RowBox[{
     RowBox[{"cd", "[", "i", "]"}], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}]}], "}"}]], "Output",
 CellLabel->
  "Out[59]=",ExpressionUUID->"2407182b-0978-40e6-8ac8-3c498a146619"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionDensity2", "=", 
  RowBox[{"ToCanonical", "@", 
   RowBox[{"NoScalar", "@", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ToMetric", "[", "g", "]"}], "[", 
         RowBox[{
         "LGravEinstein", "+", "LFieldEinstein", "+", "LMatterEinstein"}], 
         "]"}], "/.", "RulesqrtF"}], "/.", "RuleF\[CurlyPhi]"}], "/.", 
      RowBox[{
       RowBox[{"Fof\[Chi]", "[", 
        RowBox[{"\[Chi]", "[", "]"}], "]"}], "->", 
       RowBox[{"Fof\[CurlyPhi]", "[", 
        RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}]}]}], "]"}]}]}]}]], "Input",
 CellLabel->"In[60]:=",ExpressionUUID->"b2ce4316-1e83-4124-8407-f085d9bdcc65"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[
     SubscriptBox["\[ScriptCapitalL]", "M"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LMatterJ[],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", "\[Del]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], "2"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["V", "E"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VE,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Chi][],
     Editable->False], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["F",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Fof\[CurlyPhi],
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Sigma]$13101", "\[Sigma]$13102"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Sigma]$13101, $CellContext`\[Sigma]$13102],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Sigma]$13101"], "\[Chi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Sigma]$13101][
     $CellContext`\[Chi][]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Sigma]$13102"], "\[Chi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Sigma]$13102][
     $CellContext`\[Chi][]],
    Editable->False]}], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Sigma]$13101", "\[Sigma]$13102"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Sigma]$13101, $CellContext`\[Sigma]$13102],
     
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$13102"], 
       SubscriptBox["\[Del]", "\[Sigma]$13101"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$13102][
      $CellContext`CD[-$CellContext`\[Sigma]$13101][
       $CellContext`\[CurlyPhi][]]],
     Editable->False], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Sigma]$13101", "\[Sigma]$13102"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Sigma]$13101, $CellContext`\[Sigma]$13102],
     
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$13101"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$13101][
      $CellContext`\[CurlyPhi][]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$13102"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$13102][
      $CellContext`\[CurlyPhi][]],
     Editable->False], " ", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "\[Prime]",
       MultilineFunction->None], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}], 
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Sigma]$13101", "\[Sigma]$13102"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Sigma]$13101, $CellContext`\[Sigma]$13102],
     
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$13101"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$13101][
      $CellContext`\[CurlyPhi][]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Sigma]$13102"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Sigma]$13102][
      $CellContext`\[CurlyPhi][]],
     Editable->False], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "\[Prime]\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]]}]], "Output",
 CellLabel->
  "Out[60]=",ExpressionUUID->"cf7efcde-3aed-43c4-9fbe-fa656e07ab79"]
}, Open  ]],

Cell["We add a total derivative to make it simpler", \
"Text",ExpressionUUID->"31211501-2ba6-4e0b-8e39-02aefb199799"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TotalDerivativeJordan", " ", "=", " ", 
  RowBox[{
   RowBox[{"3", "/", 
    RowBox[{"(", 
     RowBox[{"2", "\[Kappa]"}], ")"}]}], " ", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"Detg", "[", "]"}], "]"}], 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "\[Alpha]"}], "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CD", "[", "\[Alpha]", "]"}], "[", 
      RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], 
     RowBox[{
      RowBox[{"Fof\[CurlyPhi]", "'"}], "[", 
      RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"a802682d-4992-4fdd-9423-8a0ee3325645"],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "\[Alpha]"], 
         SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`CD[$CellContext`\[Alpha]][
         $CellContext`\[CurlyPhi][]]],
       Editable->False], " ", 
      RowBox[{
       SuperscriptBox[
        InterpretationBox[
         StyleBox["F",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Fof\[CurlyPhi],
         Editable->False], "\[Prime]",
        MultilineFunction->None], "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`\[CurlyPhi][]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`\[Alpha]][
        $CellContext`\[CurlyPhi][]],
       Editable->False], " ", 
      RowBox[{
       SuperscriptBox[
        InterpretationBox[
         StyleBox["F",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Fof\[CurlyPhi],
         Editable->False], "\[Prime]\[Prime]",
        MultilineFunction->None], "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False]}]]], "Output",
 CellLabel->
  "Out[61]=",ExpressionUUID->"e05b841c-e59b-49d2-8386-ccc903559111"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionDensity2Modified", " ", "=", " ", 
  RowBox[{"ToCanonical", "@", 
   RowBox[{"ContractMetric", "[", 
    RowBox[{"ActionDensity2", "+", "TotalDerivativeJordan"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[62]:=",ExpressionUUID->"1f58d740-4634-47ce-b5a3-3bb051505906"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[
     SubscriptBox["\[ScriptCapitalL]", "M"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LMatterJ[],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", "\[Del]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], "2"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["V", "E"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VE,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Chi][],
     Editable->False], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["F",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Fof\[CurlyPhi],
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "\[Chi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`\[Chi][]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[Chi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[Chi][]],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`\[CurlyPhi][]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`\[CurlyPhi][]],
     Editable->False], " ", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["F",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Fof\[CurlyPhi],
        Editable->False], "\[Prime]",
       MultilineFunction->None], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], "2"]}], 
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}]]}]], "Output",
 CellLabel->
  "Out[62]=",ExpressionUUID->"dcf1121d-d2ee-42c5-9c51-5826d6624c9d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionDensity2ModifiedIn\[CurlyPhi]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"ActionDensity2Modified", "/.", "RuleD\[Chi]ToD\[CurlyPhi]"}], 
       ")"}], "//", "NoScalar"}], "//", "ContractMetric"}], "//", 
    "Simplify"}], "//", "Expand"}]}]], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"418cd52f-0a39-4906-a03e-28f6aa6f090f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[
     SubscriptBox["\[ScriptCapitalL]", "M"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LMatterJ[],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", "\[Del]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], "2"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["V", "E"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VE,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Chi][],
     Editable->False], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[63]=",ExpressionUUID->"800fae07-d6a2-4fe5-85cb-21bdec7e358d"]
}, Open  ]],

Cell["\<\
We also change the potential and it is now in canonical form in the Jordan \
frame.\
\>", "Text",ExpressionUUID->"4be529a8-aeb9-42b5-a928-3bd2e4fd2dc5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionDensity2ModifiedIn\[CurlyPhi]2", "=", 
  RowBox[{"ActionDensity2ModifiedIn\[CurlyPhi]", "/.", 
   RowBox[{
    RowBox[{"VE", "[", 
     RowBox[{"\[Chi]", "[", "]"}], "]"}], ":>", 
    RowBox[{
     RowBox[{"VJ", "[", 
      RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], "/", 
     RowBox[{
      RowBox[{"Fof\[CurlyPhi]", "[", 
       RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], "^", "2"}]}]}]}]}]], "Input",
 
 CellLabel->"In[64]:=",ExpressionUUID->"4c38eab5-137d-442d-b645-db0a603785c7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[
     SubscriptBox["\[ScriptCapitalL]", "M"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LMatterJ[],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", "\[Del]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  RowBox[{
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["V", "J"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VJ,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[64]=",ExpressionUUID->"afbccf96-f1ad-4b84-9ef2-81f4911e9207"]
}, Open  ]],

Cell["We check that this is indeed the initial Lagrangian.", \
"Text",ExpressionUUID->"b1860db5-e409-43f7-b47c-ca090484af17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ActionDensity2ModifiedIn\[CurlyPhi]2", "-", 
      RowBox[{"(", 
       RowBox[{"LGravJordan", "+", "LFieldJordan", "+", "LMatterJordan"}], 
       ")"}]}], "/.", "RuleF\[CurlyPhi]"}], ")"}], "//", "ContractMetric"}], "//",
   "ToCanonical"}]], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"3d595036-2116-4d57-bc65-8e72a9a95f1d"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[65]=",ExpressionUUID->"8a0c9c3a-1d0b-41d5-9b9a-74d3c934d728"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variation of Action", \
"Section",ExpressionUUID->"66e42829-b7db-4b51-88ba-129329b5516f"],

Cell[TextData[StyleBox["This part can only run if you have xPert installed.",
 FontColor->RGBColor[
  1, 0, 0]]], "Text",ExpressionUUID->"53e2cccb-201f-41e2-8e44-d9c83fd7eb1e"],

Cell[CellGroupData[{

Cell["General tools to vary an action. ", \
"Subsection",ExpressionUUID->"53b1d489-c28d-49ec-addc-c0c219f1f49e"],

Cell["\<\
This is taken from the example notebook ActionVariation_Metric_Fields.nb in \
xAct-contrib/examples.\
\>", "Text",ExpressionUUID->"8e045a94-7498-4d2c-9770-140966516633"],

Cell["\<\
1) First with PerturbAction we can perturb an expression and perform \
integration by parts:

We distinguish the case where the expression is varied wrt to the metric (or \
its inverse), and the case where it is a general tensor which is varied.\
\>", "Text",
 CellChangeTimes->{{3.574086882704461*^9, 3.574086896913858*^9}, {
  3.574088447333145*^9, 3.574088457744255*^9}, {3.5740890104988327`*^9, 
  3.5740890190066357`*^9}, {3.574089246187643*^9, 3.574089275114204*^9}, {
  3.730915314989225*^9, 
  3.730915315590104*^9}},ExpressionUUID->"f90f7c81-95c6-43dc-8b9c-\
8306d47a71d8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<xAct`xPert`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CovDFormat", "=", "\"\<Prefix\>\""}], ";"}]}], "Input",
 CellLabel->"In[41]:=",ExpressionUUID->"aea6a0f9-76f9-42b5-bdd7-fd5120cb81fb"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[41]:=",ExpressionUUID->"3447f3d7-a0af-4dcc-b369-2b75ebfc8f85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPert`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xPert`  version ", "1.0.6", ", ", {2018, 2, 28}],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[41]:=",ExpressionUUID->"bbb8becd-0fc6-4f5e-9a6b-93911ed5ec4b"],

Cell[BoxData["\<\"CopyRight (C) 2005-2020, David Brizuela, Jose M. \
Martin-Garcia and Guillermo A. Mena Marugan, under the General Public \
License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[41]:=",ExpressionUUID->"797134e8-c309-4145-92cf-aacefc44ad14"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[41]:=",ExpressionUUID->"5f2a30d1-21b9-42b7-961b-ab96995b74a5"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[41]:=",ExpressionUUID->"9f89b168-e0b3-4b95-b2e4-d1dce99fcb09"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[41]:=",ExpressionUUID->"909b06f2-2cc5-4619-b242-63fad401c2c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$PrePrint", 
   "\[InvisibleSpace]", "\<\" assigned value \"\>", "\[InvisibleSpace]", 
   "ScreenDollarIndices"}],
  SequenceForm[
  "** Variable ", $PrePrint, " assigned value ", 
   xAct`xTensor`ScreenDollarIndices],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[41]:=",ExpressionUUID->"a2e8a75f-915b-4204-a386-654d1662b36a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$CovDFormat", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", 
   "\[InvisibleSpace]", "\<\"Prefix\"\>", "\[InvisibleSpace]", "\<\" to \"\>",
    "\[InvisibleSpace]", "\<\"Postfix\"\>"}],
  SequenceForm[
  "** Variable ", xAct`xTensor`$CovDFormat, " changed from ", "Prefix", 
   " to ", "Postfix"],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[41]:=",ExpressionUUID->"23c0657a-df38-4c0c-8888-22787f13e0ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "MetricOn", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "MakeRule", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "None",
    "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "All"}],
  SequenceForm[
  "** Option ", xAct`xTensor`MetricOn, " of ", xAct`xTensor`MakeRule, 
   " changed from ", None, " to ", All],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[41]:=",ExpressionUUID->"ae778d3d-ae13-40ee-9025-d22a84751fc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "ContractMetrics", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "MakeRule", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`ContractMetrics, " of ", xAct`xTensor`MakeRule, 
   " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[41]:=",ExpressionUUID->"7582f1a4-fb35-4e3a-a62b-74ade37ccb03"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PerturbAction", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g_", "?", "MetricQ"}], "[", 
       RowBox[{
        RowBox[{"a_", "?", "UpIndexQ"}], ",", 
        RowBox[{"b_", "?", "UpIndexQ"}]}], "]"}], "|", 
      RowBox[{
       RowBox[{"g_", "?", "MetricQ"}], "[", 
       RowBox[{
        RowBox[{"a_", "?", "DownIndexQ"}], ",", 
        RowBox[{"b_", "?", "DownIndexQ"}]}], "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pertexpr", ",", "res", ",", "dgloc", ",", 
       RowBox[{"(*", 
        RowBox[{"dummyloc", ","}], "*)"}], "hp"}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dgloc", "=", 
       RowBox[{"SymbolJoin", "[", 
        RowBox[{"\"\<\[Delta]\>\"", ",", "g"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"dummyloc", "=", 
         RowBox[{"SymbolJoin", "[", 
          RowBox[{"\"\<Var\>\"", ",", "g"}], "]"}]}], ";"}], "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"hp", "=", 
       RowBox[{"Head", "@", 
        RowBox[{"Perturbation", "[", 
         RowBox[{"g", "[", 
          RowBox[{
           RowBox[{"DownIndex", "@", "a"}], ",", 
           RowBox[{"DownIndex", "@", "b"}]}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"hp", "===", "Perturbation"}], ",", 
        RowBox[{"DefMetricPerturbation", "[", 
         RowBox[{"g", ",", "dgloc", ",", 
          RowBox[{"SymbolJoin", "[", 
           RowBox[{"\"\<\[Epsilon]\>\"", ",", "g"}], "]"}]}], "]"}], ",", 
        RowBox[{"dgloc", "=", "hp"}]}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Block", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"$DefInfoQ", "=", "False"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"!", 
             RowBox[{"xTensorQ", "@", "dummyloc"}]}], ",", 
            RowBox[{"DefTensor", "[", 
             RowBox[{
              RowBox[{"dummyloc", "[", 
               RowBox[{"a", ",", "b"}], "]"}], ",", 
              RowBox[{"First", "@", 
               RowBox[{"DependenciesOfTensor", "@", "g"}]}], ",", 
              RowBox[{"Symmetric", "[", 
               RowBox[{"{", 
                RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "]"}]}], "]"}], 
          ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"pertexpr", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"DownIndexQ", "[", "a", "]"}], ",", "1", ",", 
               RowBox[{"-", "1"}]}], "]"}], ")"}], "*", 
            RowBox[{"ToCanonical", "@", 
             RowBox[{"ContractMetric", "@", 
              RowBox[{"ExpandPerturbation", "@", 
               RowBox[{"Perturbation", "[", "expr", "]"}]}]}]}]}], 
           RowBox[{"(*", 
            RowBox[{"/.", 
             RowBox[{
              RowBox[{"dgloc", "[", 
               RowBox[{
                RowBox[{"LI", "[", "1", "]"}], ",", "inds__"}], "]"}], 
              "\[RuleDelayed]", 
              RowBox[{"dummyloc", "[", "inds", "]"}]}]}], "*)"}], "/.", 
           RowBox[{
            RowBox[{"Perturbation", "[", "tens_", "]"}], "\[RuleDelayed]", 
            "0"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"res", "=", 
          RowBox[{"ToCanonical", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"SameDummies", "@", 
              RowBox[{"ContractMetric", "@", 
               RowBox[{
                RowBox[{"VarD", "[", 
                 RowBox[{
                  RowBox[{"dgloc", "[", 
                   RowBox[{
                    RowBox[{"LI", "[", "1", "]"}], ",", "a", ",", "b"}], 
                   "]"}], ",", 
                  RowBox[{"CovDOfMetric", "[", "g", "]"}]}], "]"}], "[", 
                "pertexpr", "]"}]}]}], ")"}], "/.", 
            RowBox[{
             RowBox[{"delta", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"LI", "[", "n_", "]"}]}], ",", 
               RowBox[{"LI", "[", "m_", "]"}]}], "]"}], "\[RuleDelayed]", 
             RowBox[{"KroneckerDelta", "[", 
              RowBox[{
               RowBox[{"NoScalar", "[", "n", "]"}], ",", 
               RowBox[{"NoScalar", "[", "m", "]"}]}], "]"}]}]}], "]"}]}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "res"}]}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PerturbAction", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"tensor_", "?", "xTensorQ"}], ",", "covd_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"res", ",", "dummyloc", ",", "pertexpr", ",", "inds"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Block", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"$DefInfoQ", "=", "False"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"dummyloc", "=", 
          RowBox[{"SymbolJoin", "[", 
           RowBox[{"\"\<Var\>\"", ",", "tensor"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"inds", "=", 
          RowBox[{"DummyIn", "/@", 
           RowBox[{"SlotsOfTensor", "[", "tensor", "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"xTensorQ", "[", "dummyloc", "]"}]}], ",", 
           RowBox[{"DefTensor", "[", 
            RowBox[{
             RowBox[{"dummyloc", "@@", "inds"}], ",", 
             RowBox[{"First", "@", 
              RowBox[{"DependenciesOfTensor", "@", "tensor"}]}]}], "]"}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"SymmetryGroupOfTensor", "[", "dummyloc", "]"}], "^=", 
          RowBox[{"SymmetryGroupOfTensor", "[", "tensor", "]"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"pertexpr", "=", 
          RowBox[{"(", 
           RowBox[{"ToCanonical", "@", 
            RowBox[{"ContractMetric", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"ExpandPerturbation", "@", 
                RowBox[{"Perturbation", "[", "expr", "]"}]}], "/.", 
               RowBox[{
                RowBox[{"Perturbation", "[", 
                 RowBox[{
                  RowBox[{"tens_", "?", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"#", "=!=", "tensor"}], ")"}], "&"}], ")"}]}], 
                  "[", "ar___", "]"}], "]"}], "\[RuleDelayed]", "0"}]}], "/.", 
              RowBox[{
               RowBox[{"Perturbation", "[", 
                RowBox[{"tensor", "[", "ind___", "]"}], "]"}], 
               "\[RuleDelayed]", 
               RowBox[{"dummyloc", "[", "ind", "]"}]}]}], "]"}]}], ")"}]}], 
         ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"res", "=", 
          RowBox[{"ToCanonical", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"SameDummies", "@", 
              RowBox[{"ContractMetric", "@", 
               RowBox[{
                RowBox[{"VarD", "[", 
                 RowBox[{
                  RowBox[{"dummyloc", "@@", "inds"}], ",", "covd"}], "]"}], 
                "[", "pertexpr", "]"}]}]}], ")"}], "/.", 
            RowBox[{
             RowBox[{"delta", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"LI", "[", "n_", "]"}]}], ",", 
               RowBox[{"LI", "[", "m_", "]"}]}], "]"}], "\[RuleDelayed]", 
             RowBox[{"KroneckerDelta", "[", 
              RowBox[{
               RowBox[{"NoScalar", "[", "n", "]"}], ",", 
               RowBox[{"NoScalar", "[", "m", "]"}]}], "]"}]}]}], "]"}]}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "res"}]}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PerturbAction", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"tensor_", "[", "inds___", "]"}]}], "]"}], ":=", 
  RowBox[{"PerturbAction", "[", 
   RowBox[{"expr", ",", 
    RowBox[{"tensor", "[", "inds", "]"}], ",", 
    RowBox[{"CovDOfMetric", "@", 
     RowBox[{"First", "@", "$Metrics"}]}]}], "]"}]}]}], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"ae96da2b-d45f-4da5-8c34-ea6d40381c93"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PerturbAction", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{
     RowBox[{"tensor_", "?", "xTensorQ"}], "[", "inds___", "]"}], ",", 
    "covd_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"res", ",", "dummyloc", ",", "pertexpr"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"$DefInfoQ", "=", "False"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dummyloc", "=", 
         RowBox[{"SymbolJoin", "[", 
          RowBox[{"\"\<Var\>\"", ",", "tensor"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"inds", "=", 
           RowBox[{"DummyIn", "/@", 
            RowBox[{"SlotsOfTensor", "[", "tensor", "]"}]}]}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"xTensorQ", "[", "dummyloc", "]"}]}], ",", 
          RowBox[{"DefTensor", "[", 
           RowBox[{
            RowBox[{"dummyloc", "[", "inds", "]"}], ",", 
            RowBox[{"First", "@", 
             RowBox[{"DependenciesOfTensor", "@", "tensor"}]}]}], "]"}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", "dummyloc", "]"}], "^=", 
         RowBox[{"SymmetryGroupOfTensor", "[", "tensor", "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"pertexpr", "=", 
         RowBox[{"(", 
          RowBox[{"ToCanonical", "@", 
           RowBox[{"ContractMetric", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"ExpandPerturbation", "@", 
               RowBox[{"Perturbation", "[", "expr", "]"}]}], "/.", 
              RowBox[{
               RowBox[{"Perturbation", "[", 
                RowBox[{
                 RowBox[{"tens_", "?", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"#", "=!=", "tensor"}], ")"}], "&"}], ")"}]}], 
                 "[", "ar___", "]"}], "]"}], "\[RuleDelayed]", "0"}]}], "/.", 
             
             RowBox[{
              RowBox[{"Perturbation", "[", 
               RowBox[{"tensor", "[", "ind___", "]"}], "]"}], 
              "\[RuleDelayed]", 
              RowBox[{"dummyloc", "[", "ind", "]"}]}]}], "]"}]}], ")"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", "pertexpr", "]"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"res", "=", 
         RowBox[{"ToCanonical", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"SameDummies", "@", 
             RowBox[{"ContractMetric", "@", 
              RowBox[{
               RowBox[{"VarD", "[", 
                RowBox[{
                 RowBox[{"dummyloc", "[", "inds", "]"}], ",", "covd"}], "]"}],
                "[", "pertexpr", "]"}]}]}], ")"}], "/.", 
           RowBox[{
            RowBox[{"delta", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"LI", "[", "n_", "]"}]}], ",", 
              RowBox[{"LI", "[", "m_", "]"}]}], "]"}], "\[RuleDelayed]", 
            RowBox[{"KroneckerDelta", "[", 
             RowBox[{
              RowBox[{"NoScalar", "[", "n", "]"}], ",", 
              RowBox[{"NoScalar", "[", "m", "]"}]}], "]"}]}]}], "]"}]}], 
        ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "res"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"1501b330-a431-4b8f-9d3a-7f93ce915d42"],

Cell["\<\
2) Then the function VarAction is used to perturb the Lagrangian times the \
determinant of the metric.\
\>", "Text",
 CellChangeTimes->{
  3.730915328339765*^9},ExpressionUUID->"145e9ce3-313c-4eee-bb19-\
8750d9ea57e9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"VarAction", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{
      RowBox[{"g_", "?", "MetricQ"}], "[", 
      RowBox[{"as__", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"UpIndexQ", "[", "#", "]"}], "||", 
           RowBox[{"DownIndexQ", "[", "#", "]"}]}], ")"}], "&"}], ")"}]}], 
      "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "sqrtg", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sqrtg", "=", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"SignDetOfMetric", "[", "g", "]"}], 
         RowBox[{
          RowBox[{"Determinant", "[", "g", "]"}], "[", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ToCanonical", "[", 
       RowBox[{
        RowBox[{"PerturbAction", "[", 
         RowBox[{"expr", ",", 
          RowBox[{"g", "[", "as", "]"}]}], "]"}], "+", 
        RowBox[{
         RowBox[{"ReplaceDummies", "@", "expr"}], "*", 
         RowBox[{
          RowBox[{"PerturbAction", "[", 
           RowBox[{"sqrtg", ",", 
            RowBox[{"g", "[", "as", "]"}]}], "]"}], "/", "sqrtg"}]}]}], " ", 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VarAction", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"tensor_", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"xTensorQ", "[", "#", "]"}], "&&", 
         RowBox[{"Not", "[", 
          RowBox[{"MetricQ", "[", "#", "]"}], "]"}]}], ")"}], "&"}], ")"}]}], 
    ",", 
    RowBox[{"g_", "?", "MetricQ"}]}], "]"}], ":=", 
  RowBox[{"PerturbAction", "[", 
   RowBox[{"expr", ",", "tensor", ",", 
    RowBox[{"CovDOfMetric", "[", "g", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VarAction", "[", 
     RowBox[{"expr_", ",", 
      RowBox[{"tensor_", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"xTensorQ", "[", "#", "]"}], "&&", 
           RowBox[{"Not", "[", 
            RowBox[{"MetricQ", "[", "#", "]"}], "]"}]}], ")"}], "&"}], 
        ")"}]}]}], "]"}], ":=", 
    RowBox[{"VarAction", "[", 
     RowBox[{"expr", ",", "tensor", ",", 
      RowBox[{"First", "@", "$Metrics"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Revoir", " ", "la", " ", 
    RowBox[{"syntaxe", ".", " ", "On"}], " ", "precise", " ", "la", " ", 
    "metrique", " ", "ou", " ", "on", " ", "precise", " ", "la", " ", 
    "derivee", " ", "covariante", 
    RowBox[{"??", "?"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VarAction", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{
     RowBox[{"tensor_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"xTensorQ", "[", "#", "]"}], "&&", 
          RowBox[{"Not", "[", 
           RowBox[{"MetricQ", "[", "#", "]"}], "]"}]}], ")"}], "&"}], ")"}]}],
      "[", "inds___", "]"}], ",", 
    RowBox[{"g_", "?", "MetricQ"}]}], "]"}], ":=", 
  RowBox[{"PerturbAction", "[", 
   RowBox[{"expr", ",", 
    RowBox[{"tensor", "[", "inds", "]"}], ",", 
    RowBox[{"CovDOfMetric", "[", "g", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VarAction", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{
      RowBox[{"tensor_", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"xTensorQ", "[", "#", "]"}], "&&", 
           RowBox[{"Not", "[", 
            RowBox[{"MetricQ", "[", "#", "]"}], "]"}]}], ")"}], "&"}], 
        ")"}]}], "[", "inds___", "]"}]}], "]"}], ":=", 
   RowBox[{"VarAction", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"tensor", "[", "inds", "]"}], ",", 
     RowBox[{"First", "@", "$Metrics"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"75b81cb5-6293-4a6a-a556-eca05fb27c2d"],

Cell["\<\
So the expr in VarAction must be the Lagrangian density of the theory.\
\>", "Text",ExpressionUUID->"20bf36a3-0024-477c-876a-d461363491b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Varying the Lagrangian in Jordan frame", \
"Subsection",ExpressionUUID->"bec5f763-cab4-4561-b52a-40b2f23af618"],

Cell["\<\
We need to explain how the Lagrangian of Matter is to be varied as we do not \
provide an explicit expression for it\
\>", "Text",ExpressionUUID->"fbf8c5d4-b50e-4cf4-b08a-f50f823d9719"],

Cell["\<\
We define a stress-energy tensor in Jordan frame\.00\.00\.00\.00ss energy \
tensor of matter\
\>", "Text",ExpressionUUID->"96471fa1-4442-4ef9-9a33-c562f676821f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"TJ", "[", 
    RowBox[{
     RowBox[{"-", "\[Mu]"}], ",", 
     RowBox[{"-", "\[Nu]"}]}], "]"}], ",", "M", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "\[Mu]"}], ",", 
      RowBox[{"-", "\[Nu]"}]}], "}"}], "]"}], ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(T\), \(J\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[66]:=",ExpressionUUID->"3c9c53b8-6969-4a06-b2c1-2603cf42ccf3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TJ", "[", 
    RowBox[{
     RowBox[{"-", "\[Mu]"}], ",", 
     RowBox[{"-", "\[Nu]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`TJ[-$CellContext`\[Mu], -$CellContext`\[Nu]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[66]:=",ExpressionUUID->"dce28b77-7ce4-4c72-a215-c9e034cd18f1"]
}, Open  ]],

Cell["\<\
We put this adhoc rule which is a hard - coding of the definition of the \
stress energy tensor from the Lagrangian density.\
\>", "Text",ExpressionUUID->"e57ec8b6-d76b-4085-823e-3458fe99a55b"],

Cell[BoxData[
 RowBox[{"LMatterJ", "/:", 
  RowBox[{"Perturbation", "[", 
   RowBox[{"LMatterJ", "[", "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "2"}], ")"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"TJ", "[", 
      RowBox[{
       RowBox[{"-", "\[Mu]"}], ",", 
       RowBox[{"-", "\[Nu]"}]}], "]"}], "-", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{
        RowBox[{"-", "\[Mu]"}], ",", 
        RowBox[{"-", "\[Nu]"}]}], "]"}], 
      RowBox[{"LMatterJ", "[", "]"}]}]}], ")"}], 
   RowBox[{"ExpandPerturbation", "@", 
    RowBox[{"Perturbation", "[", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], ",", "1"}], 
     "]"}]}]}]}]], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"fd73a7a0-a32a-43a5-9074-b00a6796c94c"],

Cell["\<\
We check the variation Lagrangian density times Sqrt of determingnat of metric.
remember that xPert perturbs the metric, not its inverse (hence the sign \
difference).\
\>", "Text",ExpressionUUID->"5154173c-3fe9-4a69-87f4-16cfbcd34776"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbation", "@", 
    RowBox[{"Perturbation", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Detg", "[", "]"}], "]"}], 
      RowBox[{"LMatterJ", "[", "]"}]}], "]"}]}], "//", "ContractMetric"}], "//",
   "ToCanonical"}]], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"4235368b-1507-4c34-900c-bcedd431a25f"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[ScriptCapitalL]", "M"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LMatterJ[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", 
       InterpretationBox[
        StyleBox[
         OverscriptBox["g", 
          OverscriptBox[
           StyleBox["~",
            FontColor->RGBColor[0, 0, 0]], 
           StyleBox["~",
            FontColor->RGBColor[0, 0, 0]]]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Detg[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[
      $CellContext`Detg[]],
     Editable->False]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]]}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubscriptBox["\[ScriptCapitalL]", "M"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LMatterJ[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"\[Mu]", "\[Nu]"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"\[Mu]", "\[Nu]"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        SuperscriptBox["T", "J"], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TJ[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[54]=",ExpressionUUID->"5bbf909e-d630-4789-8939-fb995a5006dc"]
}, Open  ]],

Cell["Jordan frame equations", \
"Text",ExpressionUUID->"e52e6972-7ac9-4d58-b65a-9a9780fdfe28"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LdensityJordan", " ", "=", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{
      "LGravJordan", "+", "LFieldJordan", "+", "LMatterJordan", "+", 
       "TotalDerivativeJordan"}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Detg", "[", "]"}], "]"}]}], "]"}], "/.", 
   "RuleF\[CurlyPhi]"}]}], "\[IndentingNewLine]", 
 RowBox[{"EFEJordan", "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"VarAction", "[", 
      RowBox[{
       RowBox[{"2", "\[Kappa]", " ", "LdensityJordan"}], ",", 
       RowBox[{"g", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}], "]"}], "//", 
     "ContractMetric"}], "//", "ToCanonical"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{"KGJordan", "=", 
  RowBox[{"VarAction", "[", 
   RowBox[{"LdensityJordan", ",", 
    RowBox[{"\[CurlyPhi]", "[", "]"}]}], "]"}]}]}], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"548ead46-7b30-4e09-b2c8-ce0383014ee3"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubscriptBox["\[ScriptCapitalL]", "M"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LMatterJ[],
   Editable->False], "+", 
  FractionBox[
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", "\[Del]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubscriptBox["V", "J"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`VJ,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox["\[CurlyPhi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CurlyPhi][],
    Editable->False], "]"}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], 
       SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`CD[$CellContext`\[Alpha]][
       $CellContext`\[CurlyPhi][]]],
     Editable->False], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`\[CurlyPhi][]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`\[CurlyPhi][]],
     Editable->False], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "\[Prime]\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]]}]], "Output",
 CellLabel->"Out[55]=",ExpressionUUID->"0f39dad9-6b4d-42f2-aec0-6dac81379fce"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefParameter", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parameter \"\>", "\[InvisibleSpace]", 
   "\[Epsilon]g", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefParameter, ": Defining ", 
   "parameter ", $CellContext`\[Epsilon]g, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[55]:=",ExpressionUUID->"5a01c61f-1d2c-4486-a57e-1aa3ab201fae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Delta]g", "[", 
    RowBox[{
     RowBox[{"LI", "[", "\<\"order\"\>", "]"}], ",", 
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Delta]g[
    xAct`xTensor`LI["order"], -$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[55]:=",ExpressionUUID->"cda3599c-9449-4b25-9666-7c2c48fd7f41"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox["F",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Fof\[CurlyPhi],
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["F",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Fof\[CurlyPhi],
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[Del]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        SuperscriptBox["T", "J"], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TJ[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["V", "J"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VJ,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Mu]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Mu]][
     $CellContext`\[CurlyPhi][]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Nu]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Nu]][
     $CellContext`\[CurlyPhi][]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], 
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`\[CurlyPhi][]]],
    Editable->False], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "\[Prime]",
     MultilineFunction->None], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Nu]"], 
      SubscriptBox["\[Del]", "\[Mu]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Nu]][
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`\[CurlyPhi][]]],
    Editable->False], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "\[Prime]",
     MultilineFunction->None], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]],
    Editable->False], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "\[Prime]\[Prime]",
     MultilineFunction->None], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Mu]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Mu]][
     $CellContext`\[CurlyPhi][]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Nu]"], "\[CurlyPhi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Nu]][
     $CellContext`\[CurlyPhi][]],
    Editable->False], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[CurlyPhi],
      Editable->False], "\[Prime]\[Prime]",
     MultilineFunction->None], "[", 
    InterpretationBox[
     StyleBox["\[CurlyPhi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CurlyPhi][],
     Editable->False], "]"}]}]}]], "Output",
 CellLabel->"Out[56]=",ExpressionUUID->"e96c1dea-0c12-4b77-8615-bc96aef6b99c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "\[Alpha]"], 
     SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`\[Alpha]][
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[CurlyPhi][]]],
   Editable->False], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", "\[Del]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubscriptBox["V", "J"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VJ,
     Editable->False], "\[Prime]",
    MultilineFunction->None], "[", 
   InterpretationBox[
    StyleBox["\[CurlyPhi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CurlyPhi][],
    Editable->False], "]"}]}]], "Output",
 CellLabel->
  "Out[57]=",ExpressionUUID->"a2cd7d4c-a6f0-4666-9a1a-6547f1cae3b6"]
}, Open  ]],

Cell["\<\
We check that if we add the total derivative, the equations are unchanged\
\>", "Text",ExpressionUUID->"0a1cb284-23ac-448e-a875-b1edc51f53c2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LdensityTotalDerivativeJordan", " ", "=", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", " ", "TotalDerivativeJordan", ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Detg", "[", "]"}], "]"}]}], "]"}], "/.", 
   "RuleF\[CurlyPhi]"}]}], "\[IndentingNewLine]", 
 RowBox[{"EFEJordan", "=", 
  RowBox[{"VarAction", "[", 
   RowBox[{
    RowBox[{"2", "\[Kappa]", " ", "LdensityTotalDerivativeJordan"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"KGJordan", "=", 
  RowBox[{"VarAction", "[", 
   RowBox[{"LdensityTotalDerivativeJordan", ",", 
    RowBox[{"\[CurlyPhi]", "[", "]"}]}], "]"}]}]}], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"90f0fa72-169e-429c-bda8-a0bcc6f726a4"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], 
       SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`CD[$CellContext`\[Alpha]][
       $CellContext`\[CurlyPhi][]]],
     Editable->False], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`\[CurlyPhi][]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Alpha]"], "\[CurlyPhi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Alpha]][
      $CellContext`\[CurlyPhi][]],
     Editable->False], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[CurlyPhi],
       Editable->False], "\[Prime]\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]]}]], "Output",
 CellLabel->"Out[58]=",ExpressionUUID->"82a387f6-ba4a-4252-b518-a184bb5b8604"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[59]=",ExpressionUUID->"2e805a44-f57b-4f8c-811f-2c05abe0e439"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[60]=",ExpressionUUID->"fce761ad-0a1f-47b0-8962-1ec216752fc9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Varying the Lagrangian in Einstein frame", \
"Subsection",ExpressionUUID->"5c7ffdc0-1600-45d8-b994-72aaa81d1254"],

Cell[TextData[StyleBox["Not very clean below.",
 FontColor->RGBColor[
  1, 0, 0]]], "Text",ExpressionUUID->"f8765bcc-88a4-418e-914a-aef326262aad"],

Cell["\<\
Einstein frame equations :

It does not work if we stay in the Einstein frame because the metric \
associated is not the base metric, 
and the VarAction alogorithm above has not really been thought for that case. \
It is base on xPert which works only for the main metric but not for frozen \
metrics. 
Maybe this could be modified one day.

However, one way to circumvent this is to Transform actively the Lagrangian \
into the Jordan frame. 
This only amounts to the active replacement of gF->g and CDgF ->CD. 
This would work well, even though it is a hack, if we had an explicit \
expression of the matter Lagrangian.

Here we intend not to specify the matter Lagrangian, but we must stress that \
minimal couplign occurs only in Jordan frame. 
This must be done with some adhoc rule, see below. Basically we put the \
result we know we must find by hand so this section is not sastisfactory.\
\>", "Text",ExpressionUUID->"4751bc14-cc64-4532-95e7-de1891b7e68c"],

Cell["We define the Lagrangian density and stress energy tensor", \
"Text",ExpressionUUID->"02c0582b-a353-4f59-b7d3-55482af7b4c2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"LMatterE", "[", "]"}], ",", "M", ",", 
   RowBox[{
   "PrintAs", "->", 
    "\"\<\!\(\*SubsuperscriptBox[\(\[ScriptCapitalL]\), \(M\), \
\(E\)]\)\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"TE", "[", 
    RowBox[{
     RowBox[{"-", "\[Mu]"}], ",", 
     RowBox[{"-", "\[Nu]"}]}], "]"}], ",", "M", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "\[Mu]"}], ",", 
      RowBox[{"-", "\[Nu]"}]}], "}"}], "]"}], ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(T\), \(E\)]\)\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"00ac875c-f55a-4a09-bba6-13a25baf85bd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"LMatterE", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`LMatterE[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[61]:=",ExpressionUUID->"79ce5387-56c3-4429-bf6d-59cd40e66881"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TE", "[", 
    RowBox[{
     RowBox[{"-", "\[Mu]"}], ",", 
     RowBox[{"-", "\[Nu]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`TE[-$CellContext`\[Mu], -$CellContext`\[Nu]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[61]:=",ExpressionUUID->"cec9a062-3d87-46e9-b8ce-46b3530e3db2"]
}, Open  ]]
}, Open  ]],

Cell["The total Lagrangian density is", \
"Text",ExpressionUUID->"ac86bf07-9322-4423-8ff3-0df8ade86651"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LdensityEinstein", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ConformalTransformation", "[", 
        RowBox[{"gF", ",", "g", ",", 
         RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", 
       RowBox[{"LGravEinstein", "+", "LFieldEinstein"}], "]"}], "+", 
      RowBox[{
       RowBox[{"LMatterE", "[", "]"}], " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Detg", "[", "]"}], "]"}]}]}], ")"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"Detg", "[", "]"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"3519bc8a-2410-46bd-a382-7072f963ced7"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[ScriptCapitalL]", "M", "E"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LMatterE[],
   Editable->False], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[Del]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False], 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa],
     Editable->False]}]], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"g", 
            StyleBox[GridBox[{
               {"\[Alpha]", "\[Beta]"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "\[Alpha]"], "\[Chi]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`\[Chi][]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "\[Beta]"], "\[Chi]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`\[Chi][]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`\[Chi][]]) $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`\[Chi][]]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubscriptBox["V", "E"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`VE,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox["\[Chi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Chi][],
    Editable->False], "]"}]}]], "Output",
 CellLabel->
  "Out[63]=",ExpressionUUID->"9afd4a51-d4ca-4f3d-b7ee-49b6abece412"]
}, Open  ]],

Cell[TextData[{
 "And we define the adhoc variation rule for the Lagrangian where we know \
that we have ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SubscriptBox["g", "J"]], TraditionalForm]],ExpressionUUID->
  "55017b50-9efc-4faa-8dab-f8800b1e8583"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalL]", "J"], TraditionalForm]],ExpressionUUID->
  "85d2d2e0-2484-4b5d-8149-db9a28439de4"],
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["g", "J"]}], TraditionalForm]],ExpressionUUID->
  "c98e50b8-0ef1-46b0-81a0-8b0b9adf9e1f"],
 ",\[Phi]) = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SubscriptBox["g", "E"]], TraditionalForm]],ExpressionUUID->
  "d02bb7e8-a1de-4f5b-b430-8ab06bf7d849"],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["F", "2"], TraditionalForm]],ExpressionUUID->
  "e78d7fe7-d0e0-4b90-9bec-703a0d65d568"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalL]", "J"], TraditionalForm]],ExpressionUUID->
  "47ee0fc6-b693-4c25-9643-6c87475d7d6f"],
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["g", "E"]}], TraditionalForm]],ExpressionUUID->
  "4e478aa1-e5a4-4a27-b62f-b0509bbac5f6"],
 "/F,\[Phi]) in the integral of the action."
}], "Text",ExpressionUUID->"92775fda-94d3-4b6f-a89b-1cef76286c52"],

Cell[TextData[{
 "The variation of the total Lagrangian (Lagrangian density times the sqrt of \
the det of the metric) must be :\n(here it is implied here that the metric is \
Einstein frame one and the stress energy tensor as well) \n\n\[Delta](",
 Cell[BoxData[
  FormBox[
   SqrtBox["g"], TraditionalForm]],ExpressionUUID->
  "54258f21-c54c-47f9-95de-d2b70a22e02f"],
 "\[ScriptCapitalL]) = -(1/2) ",
 Cell[BoxData[
  FormBox[
   SqrtBox["g"], TraditionalForm]],ExpressionUUID->
  "f7819045-5f57-43fa-bc2b-51c6d64f2e83"],
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"-", 
     SuperscriptBox["T", "\[Mu]\[Nu]"]}]}], TraditionalForm]],ExpressionUUID->
  "6d932752-3b78-4cc4-a799-327d2eb1ff89"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Delta]g", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "c61f6d0a-f3f7-4094-84fe-3cd7f3579c01"],
 " + f\[CloseCurlyQuote](\[Chi])/f(\[Chi]) ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["T", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "e9ffb4d9-a9f9-4583-8e73-0870b27c91c1"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "4737c5d0-08cc-4841-8f78-46ffabc633fe"],
 " \[Delta]\[Chi]) or  \[Delta](",
 Cell[BoxData[
  FormBox[
   SqrtBox["g"], TraditionalForm]],ExpressionUUID->
  "6af8385d-2a1d-445c-8cbd-b30ae1a2c473"],
 "\[ScriptCapitalL]) = -(1/2) ",
 Cell[BoxData[
  FormBox[
   SqrtBox["g"], TraditionalForm]],ExpressionUUID->
  "62d357fa-fea0-4a08-a97f-0d24d9826f48"],
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    SubscriptBox["T", "\[Mu]\[Nu]"]}], TraditionalForm]],ExpressionUUID->
  "2d3444c9-2cfc-4517-9324-239a47fa986e"],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Delta]g", "\[Mu]\[Nu]"], TraditionalForm]],
  ExpressionUUID->"518faea6-698d-4d27-b966-810035570a6e"],
 " + f\[CloseCurlyQuote](\[Chi])/f(\[Chi]) ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "a8fc335d-a207-4a52-83cf-9b85c9634fb9"],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["g", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "9927cdfe-58b0-44a5-89a8-b6b2eaefca7e"],
 " \[Delta]\[Chi]) \n\nRemember that xPert perturbs the metric, not its \
inverse. \nSo this is implemented with the following adhoc rule :"
}], "Text",ExpressionUUID->"65d23096-2ed7-4ac3-96dd-072c92f6581d"],

Cell[BoxData[
 RowBox[{"LMatterE", "/:", 
  RowBox[{"Perturbation", "[", 
   RowBox[{"LMatterE", "[", "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"TE", "[", 
       RowBox[{
        RowBox[{"-", "\[Mu]"}], ",", 
        RowBox[{"-", "\[Nu]"}]}], "]"}], "-", 
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"-", "\[Mu]"}], ",", 
         RowBox[{"-", "\[Nu]"}]}], "]"}], 
       RowBox[{"LMatterE", "[", "]"}]}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"ExpandPerturbation", "@", 
      RowBox[{"Perturbation", "[", 
       RowBox[{"g", "[", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}]}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"TE", "[", 
     RowBox[{
      RowBox[{"-", "\[Mu]"}], ",", 
      RowBox[{"-", "\[Nu]"}]}], "]"}], 
    RowBox[{"g", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], 
    RowBox[{
     RowBox[{
      RowBox[{"Fof\[Chi]", "'"}], "[", 
      RowBox[{"\[Chi]", "[", "]"}], "]"}], "/", 
     RowBox[{"Fof\[Chi]", "[", 
      RowBox[{"\[Chi]", "[", "]"}], "]"}]}], 
    RowBox[{"Perturbation", "[", 
     RowBox[{"\[Chi]", "[", "]"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[64]:=",ExpressionUUID->"474d1486-8358-4ffa-b140-c5de9e20a3e6"],

Cell["\<\
We check indeed that the variation of the total Lagrangian is the formula \
above :\
\>", "Text",ExpressionUUID->"b4f81ec1-e625-4e2c-86fa-6430d656e3fe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbation", "@", 
    RowBox[{"Perturbation", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Detg", "[", "]"}], "]"}], 
      RowBox[{"LMatterE", "[", "]"}]}], "]"}]}], "//", "ContractMetric"}], "//",
   "ToCanonical"}]], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"3d50f537-ac94-41a4-9968-29d85ec2c4de"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        SuperscriptBox["T", "E"], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TE[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]g", 
        StyleBox[GridBox[{
           {"1", "\[Mu]", "\[Nu]"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Delta]g[
     xAct`xTensor`LI[1], $CellContext`\[Mu], $CellContext`\[Nu]],
    Editable->False]}], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", 
       InterpretationBox[
        StyleBox["\[Chi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Chi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[
      $CellContext`\[Chi][]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         SuperscriptBox["T", "E"], 
         StyleBox[GridBox[{
            {"\[Mu]", " "},
            {" ", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TE[$CellContext`\[Mu], -$CellContext`\[Mu]],
     Editable->False], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[Chi],
       Editable->False], "\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[Chi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Chi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[Chi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[Chi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Chi][],
      Editable->False], "]"}]}]]}]], "Output",
 CellLabel->
  "Out[65]=",ExpressionUUID->"024dfb40-7856-42e9-a67c-c5b11ce96ab0"]
}, Open  ]],

Cell[TextData[{
 "We then find Einstein field equation and Klein-Gordon equation. \nBy \
definition, the stress energy-tensor in the Einstein frame enters the EFE, \
and we have\n",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["T", "\[Mu]\[Nu]", "E"], TraditionalForm]],
  ExpressionUUID->"9c4376cc-bb90-4787-ab7d-4d245a349b15"],
 " = (1/F) ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["T", "\[Mu]\[Nu]", "J"], TraditionalForm]],
  ExpressionUUID->"59475e70-0656-4626-aa5c-ce04eb357c6f"],
 ".\n\nThe Klein-Gordon has the extra coupling to the trace of the \
stress-energy tensor."
}], "Text",ExpressionUUID->"db28eebc-b908-4306-9916-03d94263e4b9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"EFEEinstein", "=", 
  RowBox[{"VarAction", "[", 
   RowBox[{
    RowBox[{"2", "\[Kappa]", " ", "LdensityEinstein"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"KGEinstein", "=", 
  RowBox[{
   RowBox[{"VarAction", "[", 
    RowBox[{"LdensityEinstein", ",", 
     RowBox[{"\[Chi]", "[", "]"}]}], "]"}], "//", "NoScalar"}]}]}], "Input",
 CellLabel->"In[66]:=",ExpressionUUID->"203f86a4-bf72-4d20-a550-cfa3ea14c903"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[Del]", "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Mu]", "\[Nu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCD[-$CellContext`\[Mu], -$CellContext`\[Nu]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[Del]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["(",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"g", 
            StyleBox[GridBox[{
               {"\[Alpha]", "\[Beta]"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "\[Alpha]"], "\[Chi]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`\[Chi][]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "\[Beta]"], "\[Chi]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`\[Chi][]],
        Editable->False]}], 
      StyleBox[")",
       FontColor->RGBColor[1, 0, 0]]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Scalar[($CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`\[Chi][]]) $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`\[Chi][]]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        SuperscriptBox["T", "E"], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TE[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Mu], -$CellContext`\[Nu]],
    Editable->False], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["V", "E"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VE,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Chi][],
     Editable->False], "]"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Kappa]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Mu]"], "\[Chi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Mu]][
     $CellContext`\[Chi][]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Nu]"], "\[Chi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Nu]][
     $CellContext`\[Chi][]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[66]=",ExpressionUUID->"7e27da1a-2aaf-4a0b-896e-aa422a7ae11a"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "\[Alpha]"], 
     SuperscriptBox["\[Del]", "\[Alpha]"], "\[Chi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`\[Alpha]][
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[Chi][]]],
   Editable->False], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         SuperscriptBox["T", "E"], 
         StyleBox[GridBox[{
            {"\[Alpha]", " "},
            {" ", "\[Alpha]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TE[$CellContext`\[Alpha], -$CellContext`\[Alpha]],
     Editable->False], " ", 
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Fof\[Chi],
       Editable->False], "\[Prime]",
      MultilineFunction->None], "[", 
     InterpretationBox[
      StyleBox["\[Chi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Chi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Fof\[Chi],
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[Chi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Chi][],
      Editable->False], "]"}]}]], "-", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubscriptBox["V", "E"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VE,
     Editable->False], "\[Prime]",
    MultilineFunction->None], "[", 
   InterpretationBox[
    StyleBox["\[Chi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Chi][],
    Editable->False], "]"}]}]], "Output",
 CellLabel->
  "Out[67]=",ExpressionUUID->"f3ab531b-7497-4b97-a9cf-a3b75cced90a"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1023, 782.25},
WindowMargins->{{Automatic, 171.75}, {Automatic, 21.75}},
Visible->True,
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[{
      ButtonBox[
      "\"\[Dagger]\"", ButtonFunction :> Exit[], Appearance -> Automatic, 
       Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluatorStart"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\[RightTriangle]\"", ButtonFunction :> 
       FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateNotebook"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"EvalInit\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateInitialization"]], Evaluator -> None,
        Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"Init\"", 
       ButtonFunction :> (Module[{Utility`Toolbar`cell = NotebookSelection[
             SelectedNotebook[]], Utility`Toolbar`isInit}, 
          Utility`Toolbar`isInit = ReplaceAll[InitializationCell, 
             Options[Utility`Toolbar`cell, InitializationCell]]; If[
            TrueQ[
             Or[
             Utility`Toolbar`isInit == True, Utility`Toolbar`isInit == On]], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> False], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> True]]]; 
        Null), Appearance -> Automatic, Evaluator -> Automatic, Method -> 
       "Preemptive"], 
      ButtonBox["\"DeInit\"", ButtonFunction :> SetOptions[
         NotebookSelection[
          SelectedNotebook[]], InitializationCell -> False], Appearance -> 
       Automatic, Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"\[DeleteKey]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["DeleteGeneratedCells"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"]}, "Row", 
     DisplayFunction -> (
      RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
        "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
        "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ), 
     InterpretationFunction -> (RowBox[{"Row", "[", 
        RowBox[{"{", 
          RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
          "}"}], "]"}]& )]], "DockedCell"]},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"13.3 for Linux x86 (64-bit) (July 24, 2023)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "PastelColor.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"d5a261cc-427a-495a-8802-fcb83c286279"
]

